/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerberos.messages.value;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.kerberos.messages.value.HostAddressType;

public class HostAddress {
    public static final int ADDR_LEN_INET = 4;
    public static final int ADDR_LEN_CHAOS = 2;
    public static final int ADDR_LEN_OSI = 0;
    public static final int ADDR_LEN_XNS = 6;
    public static final int ADDR_LEN_APPLETALK = 3;
    public static final int ADDR_LEN_DECNET = 2;
    private static byte[] localInetAddress;
    private HostAddressType _addressType;
    private byte[] _address;

    public HostAddress() {
        try {
            this._addressType = HostAddressType.ADDRTYPE_INET;
            this._address = HostAddress.getLocalInetAddress();
        }
        catch (UnknownHostException uhe) {
            uhe.printStackTrace();
        }
    }

    public HostAddress(HostAddressType addressType, byte[] address) {
        this._addressType = addressType;
        this._address = address;
    }

    public HostAddress(InetAddress internetAddress) {
        this._addressType = HostAddressType.ADDRTYPE_INET;
        byte[] newAddress = internetAddress.getAddress();
        this._address = new byte[newAddress.length];
        System.arraycopy(newAddress, 0, this._address, 0, newAddress.length);
    }

    public boolean equals(HostAddress h) {
        if (this._addressType != h._addressType || this._address != null && h._address == null || this._address == null && h._address != null) {
            return false;
        }
        if (this._address != null && h._address != null) {
            if (this._address.length != h._address.length) {
                return false;
            }
            for (int i = 0; i < this._address.length; ++i) {
                if (this._address[i] == h._address[i]) continue;
                return false;
            }
        }
        return true;
    }

    public static byte[] getLocalInetAddress() throws UnknownHostException {
        if (localInetAddress == null) {
            localInetAddress = InetAddress.getLocalHost().getAddress();
        }
        byte[] result = new byte[localInetAddress.length];
        System.arraycopy(localInetAddress, 0, result, 0, localInetAddress.length);
        return result;
    }

    public byte[] getAddress() {
        return this._address;
    }

    public HostAddressType getAddressType() {
        return this._addressType;
    }
}

