/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.common.berlib.asn1;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import org.apache.asn1.ber.digester.rules.ByteAccumulator;
import org.apache.asn1.codec.EncoderException;
import org.apache.asn1.codec.stateful.EncoderCallback;
import org.apache.asn1.codec.stateful.EncoderMonitor;
import org.apache.asn1.codec.stateful.StatefulEncoder;
import org.apache.ldap.common.berlib.asn1.BufferUtils;
import org.apache.ldap.common.berlib.asn1.encoder.SnickersLdapEncoder;
import org.apache.ldap.common.message.spi.Provider;
import org.apache.ldap.common.message.spi.ProviderEncoder;
import org.apache.ldap.common.message.spi.ProviderException;

public class SnickersEncoder
implements ProviderEncoder {
    private final Provider provider;
    private final OutputCallback outCb;
    private final AccumulatorCallback accCb;
    private final SnickersLdapEncoder encoder;

    public SnickersEncoder(Provider provider) {
        this.provider = provider;
        this.outCb = new OutputCallback();
        this.accCb = new AccumulatorCallback();
        this.encoder = new SnickersLdapEncoder();
        this.encoder.setCallback(this.outCb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void encodeBlocking(Object lock, OutputStream out, Object obj) throws ProviderException {
        SnickersLdapEncoder snickersLdapEncoder = this.encoder;
        synchronized (snickersLdapEncoder) {
            this.outCb.attach(out);
            this.encoder.setCallback(this.outCb);
            try {
                this.encoder.encode(obj);
            }
            catch (EncoderException e) {
                ProviderException pe = new ProviderException(this.provider, "Snickers encoder failed to encode object: " + obj);
                throw pe;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer encodeBlocking(Object obj) throws ProviderException {
        SnickersLdapEncoder snickersLdapEncoder = this.encoder;
        synchronized (snickersLdapEncoder) {
            this.encoder.setCallback(this.accCb);
            try {
                this.encoder.encode(obj);
            }
            catch (EncoderException e) {
                ProviderException pe = new ProviderException(this.provider, "Snickers encoder failed to encode object: " + obj);
                throw pe;
            }
            return this.accCb.getEncoded();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] encodeToArray(Object obj) throws ProviderException {
        SnickersLdapEncoder snickersLdapEncoder = this.encoder;
        synchronized (snickersLdapEncoder) {
            this.encoder.setCallback(this.accCb);
            try {
                this.encoder.encode(obj);
            }
            catch (EncoderException e) {
                ProviderException pe = new ProviderException(this.provider, "Snickers encoder failed to encode object: " + obj);
                throw pe;
            }
            return BufferUtils.getArray(this.accCb.getEncoded());
        }
    }

    public Provider getProvider() {
        return this.provider;
    }

    public void encode(Object obj) throws EncoderException {
        this.encoder.encode(obj);
    }

    public void setCallback(EncoderCallback cb) {
        this.encoder.setCallback(cb);
    }

    public void setEncoderMonitor(EncoderMonitor monitor) {
        this.encoder.setEncoderMonitor(monitor);
    }

    class OutputCallback
    implements EncoderCallback {
        private WritableByteChannel channel = null;

        OutputCallback() {
        }

        public void encodeOccurred(StatefulEncoder encoder, Object encoded) {
            try {
                this.channel.write((ByteBuffer)encoded);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        void attach(WritableByteChannel channel) {
            this.channel = channel;
        }

        void attach(OutputStream out) {
            this.channel = Channels.newChannel(out);
        }
    }

    class AccumulatorCallback
    implements EncoderCallback {
        ByteAccumulator accumulator = new ByteAccumulator();

        AccumulatorCallback() {
        }

        public void encodeOccurred(StatefulEncoder encoder, Object encoded) {
            if (encoded instanceof ByteBuffer[]) {
                ByteBuffer[] buffers = (ByteBuffer[])encoded;
                for (int ii = 0; ii < buffers.length; ++ii) {
                    this.accumulator.fill(buffers[ii]);
                }
                return;
            }
            this.accumulator.fill((ByteBuffer)encoded);
        }

        ByteBuffer getEncoded() {
            return this.accumulator.drain();
        }
    }
}

