/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.common.berlib.asn1.decoder.modifydn;

import java.nio.ByteBuffer;
import org.apache.asn1.ber.TypeClass;
import org.apache.asn1.ber.digester.rules.PrimitiveOctetStringRule;
import org.apache.asn1.ber.primitives.UniversalTag;
import org.apache.ldap.common.message.ModifyDnRequest;

public class ModifyDnRequestEntryRule
extends PrimitiveOctetStringRule {
    private boolean byPass = false;
    private ModifyDnRequest req = null;

    public ModifyDnRequestEntryRule() {
        super(UniversalTag.OCTET_STRING);
    }

    public void tag(int id, boolean isPrimitive, TypeClass typeClass) {
        this.req = (ModifyDnRequest)this.getDigester().peek();
        if (this.req.getName() != null) {
            this.byPass = true;
            return;
        }
        super.tag(id, isPrimitive, typeClass);
    }

    public void length(int length) {
        if (this.byPass) {
            return;
        }
        super.length(length);
    }

    public void value(ByteBuffer buf) {
        if (this.byPass) {
            return;
        }
        super.value(buf);
    }

    public void finish() {
        if (this.byPass) {
            this.req = null;
            this.byPass = false;
            return;
        }
        super.finish();
        ByteBuffer buf = (ByteBuffer)this.getDigester().pop();
        byte[] octets = null;
        if (buf.limit() == buf.capacity() && buf.hasArray()) {
            octets = buf.array();
        } else {
            octets = new byte[buf.remaining()];
            buf.get(octets);
        }
        this.req.setName(new String(octets));
        this.byPass = false;
        this.req = null;
    }
}

