/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.common.berlib.asn1.decoder.search;

import java.nio.ByteBuffer;
import org.apache.asn1.ber.TypeClass;
import org.apache.asn1.ber.digester.AbstractRule;
import org.apache.ldap.common.berlib.asn1.LdapTag;
import org.apache.ldap.common.filter.ExtensibleNode;

public class ExtensibleMatchRule
extends AbstractRule {
    private boolean isEnabled = true;
    private String matchingRule = null;
    private String type = null;
    private String value = null;
    private boolean dnAttributes = false;

    public void tag(int id, boolean isPrimitive, TypeClass typeClass) {
        int tagCount = this.getDigester().getTagCount();
        if (tagCount < 3) {
            this.isEnabled = false;
            return;
        }
        if (this.getDigester().getTag(tagCount - 2) != LdapTag.SEARCH_REQUEST.getPrimitiveTag()) {
            this.isEnabled = false;
            return;
        }
        super.tag(id, isPrimitive, typeClass);
        this.getDigester().push(this);
    }

    public void length(int length) {
        if (this.isEnabled) {
            super.length(length);
        }
    }

    public void value(ByteBuffer buf) {
        if (this.isEnabled) {
            super.value(buf);
        }
    }

    public void finish() {
        if (this.isEnabled) {
            super.finish();
            ExtensibleNode node = new ExtensibleNode(this.type, this.value, this.matchingRule, this.dnAttributes);
            if (this.getDigester().peek() == this) {
                this.getDigester().pop();
            }
            this.getDigester().push(node);
        }
        this.isEnabled = true;
        this.type = null;
        this.value = null;
        this.matchingRule = null;
        this.dnAttributes = false;
    }

    public void setMatchingRule(String matchingRule) {
        this.matchingRule = matchingRule;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setDnAttributes(boolean dnAttributes) {
        this.dnAttributes = dnAttributes;
    }
}

