/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.common.filter;

import java.math.BigInteger;
import java.util.ArrayList;
import org.apache.ldap.common.filter.AbstractExprNode;
import org.apache.ldap.common.filter.ExprNode;
import org.apache.ldap.common.filter.FilterVisitor;

public class BranchNode
extends AbstractExprNode {
    private final int m_operator;
    private ArrayList m_children = null;

    public BranchNode(int an_operator, ArrayList a_childList) {
        super(an_operator);
        this.m_children = null == a_childList ? new ArrayList(2) : a_childList;
        this.m_operator = an_operator;
        switch (this.m_operator) {
            case 10: {
                break;
            }
            case 11: {
                break;
            }
            case 9: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Logical operator argument in constructor is undefined.");
            }
        }
    }

    public BranchNode(int an_operator) {
        this(an_operator, null);
    }

    public void addNode(ExprNode a_node) {
        if (11 == this.m_operator && this.m_children.size() >= 1) {
            throw new IllegalStateException("Cannot add more than one element to a negation node.");
        }
        this.m_children.add(a_node);
    }

    public void addNodeToHead(ExprNode a_node) {
        if (11 == this.m_operator && this.m_children.size() >= 1) {
            throw new IllegalStateException("Cannot add more than one element to a negation node.");
        }
        this.m_children.add(0, a_node);
    }

    public final boolean isLeaf() {
        return false;
    }

    public ArrayList getChildren() {
        return this.m_children;
    }

    public ExprNode getChild() {
        return (ExprNode)this.m_children.get(0);
    }

    void setChildren(ArrayList a_list) {
        this.m_children = a_list;
    }

    public int getOperator() {
        return this.m_operator;
    }

    public boolean isDisjunction() {
        return 9 == this.m_operator;
    }

    public boolean isConjunction() {
        return 10 == this.m_operator;
    }

    public final boolean isNegation() {
        return 11 == this.m_operator;
    }

    public void printToBuffer(StringBuffer a_buf) {
        a_buf.append('(');
        switch (this.m_operator) {
            case 10: {
                a_buf.append("& ");
                break;
            }
            case 11: {
                a_buf.append("! ");
                break;
            }
            case 9: {
                a_buf.append("| ");
                break;
            }
            default: {
                a_buf.append("UNKNOWN");
            }
        }
        for (int ii = 0; ii < this.m_children.size(); ++ii) {
            ((ExprNode)this.m_children.get(ii)).printToBuffer(a_buf);
        }
        a_buf.append(')');
        if (null != this.getAnnotations() && this.getAnnotations().containsKey("count")) {
            a_buf.append('[');
            a_buf.append(((BigInteger)this.getAnnotations().get("count")).toString());
            a_buf.append("] ");
        } else {
            a_buf.append(' ');
        }
    }

    public static String getOperatorString(int a_operator) {
        String l_opstr = null;
        switch (a_operator) {
            case 10: {
                l_opstr = "AND";
                break;
            }
            case 11: {
                l_opstr = "NOT";
                break;
            }
            case 9: {
                l_opstr = "OR";
                break;
            }
            default: {
                l_opstr = "UNKNOWN";
            }
        }
        return l_opstr;
    }

    public String toString() {
        StringBuffer l_buf = new StringBuffer();
        l_buf.append(BranchNode.getOperatorString(this.m_operator));
        if (null != this.getAnnotations() && this.getAnnotations().containsKey("count")) {
            l_buf.append('[');
            l_buf.append(((BigInteger)this.getAnnotations().get("count")).toString());
            l_buf.append("] ");
        } else {
            l_buf.append(' ');
        }
        return l_buf.toString();
    }

    public void accept(FilterVisitor a_visitor) {
        if (a_visitor.isPrefix()) {
            ArrayList l_children = a_visitor.getOrder(this, this.m_children);
            if (a_visitor.canVisit(this)) {
                a_visitor.visit(this);
            }
            for (int ii = 0; ii < l_children.size(); ++ii) {
                ((ExprNode)l_children.get(ii)).accept(a_visitor);
            }
        } else {
            ArrayList l_children = a_visitor.getOrder(this, this.m_children);
            for (int ii = 0; ii < l_children.size(); ++ii) {
                ((ExprNode)l_children.get(ii)).accept(a_visitor);
            }
            if (a_visitor.canVisit(this)) {
                a_visitor.visit(this);
            }
        }
    }
}

