/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.common.schema;

import javax.naming.NamingException;
import javax.naming.directory.InvalidAttributeValueException;
import org.apache.ldap.common.schema.SyntaxChecker;
import org.apache.oro.text.perl.Perl5Util;

public class RegexSyntaxChecker
implements SyntaxChecker {
    private final String oid;
    private final String[] expressions;
    private final Perl5Util perl = new Perl5Util();

    public RegexSyntaxChecker(String oid, String[] matchExprArray) {
        this.expressions = matchExprArray;
        this.oid = oid;
    }

    public String getSyntaxOid() {
        return this.oid;
    }

    public boolean isValidSyntax(Object value) {
        String str = null;
        boolean match = true;
        if (value instanceof String) {
            str = (String)value;
        }
        for (int ii = 0; ii < this.expressions.length; ++ii) {
            boolean bl = match = match && this.perl.match(this.expressions[ii], str);
            if (!match) break;
        }
        return match;
    }

    public void assertSyntax(Object value) throws NamingException {
        if (this.isValidSyntax(value)) {
            return;
        }
        throw new InvalidAttributeValueException(value + " does not conform to the syntax specified by " + this.oid);
    }
}

