/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.common.util;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.apache.ldap.common.util.ArrayEnumeration;
import org.apache.ldap.common.util.NestableRuntimeException;

public class PreferencesDictionary
extends Dictionary {
    private final Preferences prefs;

    public PreferencesDictionary(Preferences prefs) {
        this.prefs = prefs;
    }

    public Preferences getPreferences() {
        return this.prefs;
    }

    public int size() {
        try {
            return this.prefs.keys().length;
        }
        catch (BackingStoreException e) {
            throw new NestableRuntimeException("can't get keys from prefs", e);
        }
    }

    public boolean isEmpty() {
        try {
            return this.prefs.keys().length == 0;
        }
        catch (BackingStoreException e) {
            throw new NestableRuntimeException("can't get keys from prefs", e);
        }
    }

    public Enumeration elements() {
        try {
            return new ArrayEnumeration(this.prefs.keys()){

                public Object nextElement() {
                    String key = (String)super.nextElement();
                    return PreferencesDictionary.this.prefs.get(key, null);
                }
            };
        }
        catch (BackingStoreException e) {
            throw new NestableRuntimeException("can't get keys from prefs", e);
        }
    }

    public Enumeration keys() {
        try {
            return new ArrayEnumeration(this.prefs.keys());
        }
        catch (BackingStoreException e) {
            throw new NestableRuntimeException("can't get keys from prefs", e);
        }
    }

    public Object get(Object key) {
        if (key instanceof String) {
            return this.prefs.get((String)key, null);
        }
        return this.prefs.get(key.toString(), null);
    }

    public Object remove(Object key) {
        Object retval = this.get(key);
        if (key instanceof String) {
            this.prefs.remove((String)key);
        } else {
            this.prefs.remove(key.toString());
        }
        return retval;
    }

    public Object put(Object key, Object value) {
        Object retval = this.get(key);
        String skey = null;
        String svalue = null;
        skey = key instanceof String ? (String)key : key.toString();
        svalue = value instanceof String ? (String)value : value.toString();
        this.prefs.put(skey, svalue);
        return retval;
    }
}

