/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.server.authn;

import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import org.apache.ldap.common.exception.LdapAuthenticationException;
import org.apache.ldap.common.exception.LdapNameNotFoundException;
import org.apache.ldap.common.name.LdapName;
import org.apache.ldap.common.util.ArrayUtils;
import org.apache.ldap.server.ContextPartition;
import org.apache.ldap.server.PartitionNexus;
import org.apache.ldap.server.authn.AbstractAuthenticator;
import org.apache.ldap.server.authn.LdapPrincipal;
import org.apache.ldap.server.db.Database;
import org.apache.ldap.server.jndi.ProviderNexusAspect;
import org.apache.ldap.server.jndi.ServerContext;

public class SimpleAuthenticator
extends AbstractAuthenticator {
    public SimpleAuthenticator() {
        super("simple");
    }

    public LdapPrincipal authenticate(ServerContext ctx) throws NamingException {
        Object userPassword;
        Attributes attributes;
        Object creds = ctx.getEnvironment().get("java.naming.security.credentials");
        if (creds == null) {
            creds = ArrayUtils.EMPTY_BYTE_ARRAY;
        } else if (creds instanceof String) {
            creds = ((String)creds).getBytes();
        }
        if (!ctx.getEnvironment().containsKey("java.naming.security.principal")) {
            throw new LdapAuthenticationException();
        }
        String principal = (String)ctx.getEnvironment().get("java.naming.security.principal");
        if (principal == null) {
            throw new LdapAuthenticationException();
        }
        LdapName principalDn = new LdapName(principal);
        PartitionNexus rootNexus = this.getAuthenticatorContext().getPartitionNexus();
        LdapName ldapName = principalDn;
        PartitionNexus partitionNexus = rootNexus;
        try {
            if (this instanceof Context && !(this instanceof ContextPartition) && !(partitionNexus instanceof Database)) {
                ProviderNexusAspect.aspectOf().ajc$before$org_apache_ldap_server_jndi_ProviderNexusAspect$1$1ba52095((Context)((Object)this));
            }
            attributes = partitionNexus.lookup(ldapName);
        }
        finally {
            if (this instanceof Context && !(this instanceof ContextPartition) && !(partitionNexus instanceof Database)) {
                ProviderNexusAspect.aspectOf().ajc$after$org_apache_ldap_server_jndi_ProviderNexusAspect$2$1ba52095((Context)((Object)this));
            }
        }
        Attributes userEntry = attributes;
        if (userEntry == null) {
            throw new LdapNameNotFoundException();
        }
        Attribute userPasswordAttr = userEntry.get("userPassword");
        if (userPasswordAttr == null) {
            userPassword = ArrayUtils.EMPTY_BYTE_ARRAY;
        } else {
            userPassword = userPasswordAttr.get();
            if (userPassword instanceof String) {
                userPassword = ((String)userPassword).getBytes();
            }
        }
        if (!ArrayUtils.isEquals(creds, userPassword)) {
            throw new LdapAuthenticationException();
        }
        return new LdapPrincipal(principalDn);
    }
}

