/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.server.jndi;

import java.util.Enumeration;
import java.util.Hashtable;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import org.apache.ldap.common.Lockable;
import org.apache.ldap.common.message.LockableAttributeImpl;
import org.apache.ldap.common.message.LockableAttributesImpl;
import org.apache.ldap.common.name.LdapName;
import org.apache.ldap.common.util.ArrayUtils;
import org.apache.ldap.common.util.StringTools;
import org.apache.ldap.server.ContextPartitionConfig;

public class PartitionConfigBuilder {
    private static final ContextPartitionConfig[] EMPTY = new ContextPartitionConfig[0];

    public static ContextPartitionConfig getContextPartitionConfig(String id, Hashtable env) throws NamingException {
        StringBuffer buf = new StringBuffer();
        ContextPartitionConfig config = new ContextPartitionConfig();
        LockableAttributesImpl attrs = new LockableAttributesImpl();
        config.setId(id);
        config.setAttributes(attrs);
        buf.append("server.db.partition.suffix.").append(id);
        String suffix = (String)env.get(buf.toString());
        if (suffix != null) {
            suffix = new LdapName(suffix).toString();
        }
        config.setSuffix(suffix);
        buf.setLength(0);
        buf.append("server.db.partition.class.").append(id);
        String partitionClass = (String)env.get(buf.toString());
        if (partitionClass != null) {
            config.setPartitionClass(partitionClass);
        }
        buf.setLength(0);
        buf.append("server.db.partition.properties.").append(id);
        String properties = (String)env.get(buf.toString());
        if (properties != null) {
            config.setProperties(properties);
        }
        buf.setLength(0);
        buf.append("server.db.partition.indices.").append(id);
        String indexList = (String)env.get(buf.toString());
        if (indexList == null || indexList.trim().length() == 0) {
            config.setIndices(ArrayUtils.EMPTY_STRING_ARRAY);
        } else {
            indexList = StringTools.deepTrim(indexList);
            config.setIndices(indexList.split(" "));
        }
        buf.setLength(0);
        buf.append("server.db.partition.attributes.").append(id);
        String keyBase = buf.toString();
        if (env.containsKey(keyBase)) {
            config.setAttributes((Attributes)env.get(keyBase));
            return config;
        }
        buf.append(".");
        keyBase = buf.toString();
        Enumeration list = env.keys();
        while (list.hasMoreElements()) {
            String attrKey = (String)list.nextElement();
            if (!attrKey.startsWith(keyBase)) continue;
            LockableAttributeImpl attr = new LockableAttributeImpl((Lockable)attrs, attrKey.substring(keyBase.length()));
            String valueList = (String)env.get(attrKey);
            if (valueList == null || valueList.trim().length() == 0) {
                attrs.put(attr);
                continue;
            }
            valueList = StringTools.deepTrim(valueList);
            String[] values = valueList.split(" ");
            int ii = 0;
            while (ii < values.length) {
                attr.add(values[ii]);
                ++ii;
            }
            attrs.put(attr);
        }
        return config;
    }

    public static ContextPartitionConfig[] getContextPartitionConfigs(Hashtable env) throws NamingException {
        String idList = (String)env.get("server.db.partitions");
        if (idList == null || idList.trim().length() == 0) {
            return EMPTY;
        }
        idList = StringTools.deepTrim(idList);
        String[] ids = idList.split(" ");
        ContextPartitionConfig[] configs = new ContextPartitionConfig[ids.length];
        int ii = 0;
        while (ii < configs.length) {
            configs[ii] = PartitionConfigBuilder.getContextPartitionConfig(ids[ii], env);
            ++ii;
        }
        return configs;
    }
}

