/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.server.jndi;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.ldap.Control;
import javax.naming.ldap.InitialLdapContext;
import org.apache.kerberos.protocol.KerberosProtocolProvider;
import org.apache.kerberos.service.KdcConfiguration;
import org.apache.kerberos.store.JndiPrincipalStoreImpl;
import org.apache.ldap.common.exception.LdapConfigurationException;
import org.apache.ldap.common.name.LdapName;
import org.apache.ldap.common.util.PropertiesUtils;
import org.apache.ldap.server.jndi.CoreContextFactory;
import org.apache.ldap.server.jndi.DeadContext;
import org.apache.ldap.server.protocol.LdapProtocolProvider;
import org.apache.mina.common.TransportType;
import org.apache.mina.registry.Service;
import org.apache.mina.registry.ServiceRegistry;
import org.apache.mina.registry.SimpleServiceRegistry;

public class ServerContextFactory
extends CoreContextFactory {
    private static final int LDAP_PORT = 389;
    private static final ServiceRegistry DEFAULT_MINA_REGISTRY;
    private static Service ldapService;
    private static Service kerberosService;
    private static ServiceRegistry minaRegistry;

    public Context getInitialContext(Hashtable env) throws NamingException {
        Context ctx = null;
        if (env.containsKey("server.operation.shutdown")) {
            if (this.provider == null) {
                return new DeadContext();
            }
            try {
                block10: {
                    try {
                        this.provider.shutdown();
                        if (minaRegistry == null) break block10;
                        if (ldapService != null) {
                            minaRegistry.unbind(ldapService);
                            ldapService = null;
                        }
                        if (kerberosService == null) break block10;
                        minaRegistry.unbind(kerberosService);
                        kerberosService = null;
                    }
                    catch (NamingException ne) {
                        throw ne;
                    }
                    catch (Throwable t) {
                        NamingException ne = new NamingException("Failed to shutdown.");
                        ne.setRootCause(t);
                        throw ne;
                    }
                }
                Object var6_3 = null;
                ctx = new DeadContext();
                this.provider = null;
                this.initialEnv = null;
            }
            catch (Throwable throwable) {
                Object var6_4 = null;
                ctx = new DeadContext();
                this.provider = null;
                this.initialEnv = null;
                throw throwable;
            }
            return ctx;
        }
        ctx = super.getInitialContext(env);
        if (this.initialEnv != null && !this.initialEnv.containsKey("server.net.disable.protocol")) {
            this.setupRegistry();
            this.startLdapProtocol();
            if (this.initialEnv.containsKey("server.enable.kerberos")) {
                this.startKerberosProtocol();
            }
        }
        return ctx;
    }

    private void setupRegistry() throws NamingException {
        ServiceRegistry registry = null;
        if (this.initialEnv.containsKey("server.net.passthru") && (registry = (ServiceRegistry)this.initialEnv.get("server.net.passthru")) != null) {
            this.initialEnv.put("server.net.passthru", "Handoff Succeeded!");
        }
        if (DEFAULT_MINA_REGISTRY == null) {
            throw new NamingException("Default MINA service registry is not available.");
        }
        if (registry == null) {
            registry = DEFAULT_MINA_REGISTRY;
        }
        minaRegistry = registry;
    }

    private void startKerberosProtocol() throws NamingException {
        Properties props = new Properties();
        Iterator list = this.initialEnv.keySet().iterator();
        while (list.hasNext()) {
            String key = (String)list.next();
            if (!(this.initialEnv.get(key) instanceof String)) continue;
            props.setProperty(key, (String)this.initialEnv.get(key));
        }
        KdcConfiguration config = new KdcConfiguration(props);
        int port = PropertiesUtils.get(this.initialEnv, (Object)"kdc.default.port", 88);
        Service service = new Service("kerberos", TransportType.DATAGRAM, new InetSocketAddress(port));
        InitialLdapContext ctx = new InitialLdapContext(this.initialEnv, new Control[0]);
        Object baseStr = this.initialEnv.get("kdc.store.searchbase");
        if (baseStr == null) {
            throw new LdapConfigurationException("Trying to start kerberos service without setting kdc.store.searchbase");
        }
        LdapName base = new LdapName((String)baseStr);
        JndiPrincipalStoreImpl store = new JndiPrincipalStoreImpl(ctx, base);
        try {
            minaRegistry.bind(service, new KerberosProtocolProvider(config, store));
            kerberosService = service;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void startLdapProtocol() throws NamingException {
        int port = PropertiesUtils.get(this.initialEnv, (Object)"server.net.ldap.port", 389);
        Service service = new Service("ldap", TransportType.SOCKET, new InetSocketAddress(port));
        try {
            minaRegistry.bind(service, new LdapProtocolProvider((Hashtable)this.initialEnv.clone()));
            ldapService = service;
        }
        catch (IOException e) {
            String msg = "Failed to bind the LDAP protocol service to the service registry: " + service;
            LdapConfigurationException lce = new LdapConfigurationException(msg);
            lce.setRootCause(e);
            throw lce;
        }
    }

    static {
        SimpleServiceRegistry tmp = null;
        try {
            tmp = new SimpleServiceRegistry();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        DEFAULT_MINA_REGISTRY = tmp;
    }
}

