/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.server.normalization;

import javax.naming.NamingException;
import org.apache.ldap.common.name.DnParser;
import org.apache.ldap.common.name.NameComponentNormalizer;
import org.apache.ldap.common.schema.AttributeType;
import org.apache.ldap.server.interceptor.BaseInterceptor;
import org.apache.ldap.server.interceptor.InterceptorContext;
import org.apache.ldap.server.interceptor.NextInterceptor;
import org.apache.ldap.server.invocation.Add;
import org.apache.ldap.server.invocation.Delete;
import org.apache.ldap.server.invocation.GetMatchedDN;
import org.apache.ldap.server.invocation.GetSuffix;
import org.apache.ldap.server.invocation.HasEntry;
import org.apache.ldap.server.invocation.IsSuffix;
import org.apache.ldap.server.invocation.List;
import org.apache.ldap.server.invocation.Lookup;
import org.apache.ldap.server.invocation.LookupWithAttrIds;
import org.apache.ldap.server.invocation.Modify;
import org.apache.ldap.server.invocation.ModifyMany;
import org.apache.ldap.server.invocation.ModifyRN;
import org.apache.ldap.server.invocation.Move;
import org.apache.ldap.server.invocation.MoveAndModifyRN;
import org.apache.ldap.server.invocation.Search;
import org.apache.ldap.server.schema.AttributeTypeRegistry;

public class NormalizationService
extends BaseInterceptor {
    private DnParser parser;

    public void init(InterceptorContext context) throws NamingException {
        AttributeTypeRegistry attributeRegistry = context.getGlobalRegistries().getAttributeTypeRegistry();
        this.parser = new DnParser(new PerComponentNormalizer(attributeRegistry));
    }

    public void destroy() {
    }

    protected void process(NextInterceptor nextInterceptor, Add call) throws NamingException {
        DnParser dnParser = this.parser;
        synchronized (dnParser) {
            call.setNormalizedName(this.parser.parse(call.getNormalizedName().toString()));
        }
        super.process(nextInterceptor, call);
    }

    protected void process(NextInterceptor nextInterceptor, Delete call) throws NamingException {
        DnParser dnParser = this.parser;
        synchronized (dnParser) {
            call.setName(this.parser.parse(call.getName().toString()));
        }
        super.process(nextInterceptor, call);
    }

    protected void process(NextInterceptor nextInterceptor, Modify call) throws NamingException {
        DnParser dnParser = this.parser;
        synchronized (dnParser) {
            call.setName(this.parser.parse(call.getName().toString()));
        }
        super.process(nextInterceptor, call);
    }

    protected void process(NextInterceptor nextInterceptor, ModifyMany call) throws NamingException {
        DnParser dnParser = this.parser;
        synchronized (dnParser) {
            call.setName(this.parser.parse(call.getName().toString()));
        }
        super.process(nextInterceptor, call);
    }

    protected void process(NextInterceptor nextInterceptor, ModifyRN call) throws NamingException {
        DnParser dnParser = this.parser;
        synchronized (dnParser) {
            call.setName(this.parser.parse(call.getName().toString()));
        }
        super.process(nextInterceptor, call);
    }

    protected void process(NextInterceptor nextInterceptor, Move call) throws NamingException {
        DnParser dnParser = this.parser;
        synchronized (dnParser) {
            call.setName(this.parser.parse(call.getName().toString()));
            call.setNewParentName(this.parser.parse(call.getNewParentName().toString()));
        }
        super.process(nextInterceptor, call);
    }

    protected void process(NextInterceptor nextInterceptor, MoveAndModifyRN call) throws NamingException {
        DnParser dnParser = this.parser;
        synchronized (dnParser) {
            call.setName(this.parser.parse(call.getName().toString()));
            call.setNewParentName(this.parser.parse(call.getNewParentName().toString()));
        }
        super.process(nextInterceptor, call);
    }

    protected void process(NextInterceptor nextInterceptor, Search call) throws NamingException {
        DnParser dnParser = this.parser;
        synchronized (dnParser) {
            call.setBaseName(this.parser.parse(call.getBaseName().toString()));
        }
        super.process(nextInterceptor, call);
    }

    protected void process(NextInterceptor nextInterceptor, HasEntry call) throws NamingException {
        DnParser dnParser = this.parser;
        synchronized (dnParser) {
            call.setName(this.parser.parse(call.getName().toString()));
        }
        super.process(nextInterceptor, call);
    }

    protected void process(NextInterceptor nextInterceptor, IsSuffix call) throws NamingException {
        DnParser dnParser = this.parser;
        synchronized (dnParser) {
            call.setName(this.parser.parse(call.getName().toString()));
        }
        super.process(nextInterceptor, call);
    }

    protected void process(NextInterceptor nextInterceptor, List call) throws NamingException {
        DnParser dnParser = this.parser;
        synchronized (dnParser) {
            call.setBaseName(this.parser.parse(call.getBaseName().toString()));
        }
        super.process(nextInterceptor, call);
    }

    protected void process(NextInterceptor nextInterceptor, Lookup call) throws NamingException {
        DnParser dnParser = this.parser;
        synchronized (dnParser) {
            call.setName(this.parser.parse(call.getName().toString()));
        }
        super.process(nextInterceptor, call);
    }

    protected void process(NextInterceptor nextInterceptor, LookupWithAttrIds call) throws NamingException {
        DnParser dnParser = this.parser;
        synchronized (dnParser) {
            call.setName(this.parser.parse(call.getName().toString()));
        }
        super.process(nextInterceptor, call);
    }

    protected void process(NextInterceptor nextInterceptor, GetMatchedDN call) throws NamingException {
        DnParser dnParser = this.parser;
        synchronized (dnParser) {
            call.setName(this.parser.parse(call.getName().toString()));
        }
        super.process(nextInterceptor, call);
    }

    protected void process(NextInterceptor nextInterceptor, GetSuffix call) throws NamingException {
        DnParser dnParser = this.parser;
        synchronized (dnParser) {
            call.setName(this.parser.parse(call.getName().toString()));
        }
        super.process(nextInterceptor, call);
    }

    class PerComponentNormalizer
    implements NameComponentNormalizer {
        private final AttributeTypeRegistry registry;

        public PerComponentNormalizer(AttributeTypeRegistry registry) {
            this.registry = registry;
        }

        public String normalizeByName(String name, String value) throws NamingException {
            AttributeType type = this.registry.lookup(name);
            return (String)type.getEquality().getNormalizer().normalize(value);
        }

        public String normalizeByOid(String oid, String value) throws NamingException {
            AttributeType type = this.registry.lookup(oid);
            return (String)type.getEquality().getNormalizer().normalize(value);
        }
    }
}

