/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.server.protocol;

import javax.naming.NamingException;
import javax.naming.ldap.LdapContext;
import org.apache.ldap.common.exception.LdapException;
import org.apache.ldap.common.message.LdapResultImpl;
import org.apache.ldap.common.message.ModifyDnRequest;
import org.apache.ldap.common.message.ModifyDnResponseImpl;
import org.apache.ldap.common.message.ResultCodeEnum;
import org.apache.ldap.common.name.LdapName;
import org.apache.ldap.common.util.ExceptionUtils;
import org.apache.ldap.server.protocol.SessionRegistry;
import org.apache.mina.protocol.ProtocolSession;
import org.apache.mina.protocol.handler.MessageHandler;

public class ModifyDnHandler
implements MessageHandler {
    public void messageReceived(ProtocolSession session, Object request) {
        ModifyDnRequest req = (ModifyDnRequest)request;
        ModifyDnResponseImpl resp = new ModifyDnResponseImpl(req.getMessageId());
        resp.setLdapResult(new LdapResultImpl(resp));
        try {
            LdapContext ctx = SessionRegistry.getSingleton().getLdapContext(session, null, true);
            String deleteRDN = String.valueOf(req.getDeleteOldRdn());
            ctx.addToEnvironment("java.naming.ldap.deleteRDN", deleteRDN);
            if (req.isMove()) {
                LdapName oldDn = new LdapName(req.getName());
                LdapName newDn = new LdapName(req.getNewSuperior());
                if (req.getNewRdn() != null) {
                    newDn.add(req.getNewRdn());
                } else {
                    newDn.add(oldDn.getRdn());
                }
                ctx.rename(new LdapName(req.getName()), newDn);
            } else {
                LdapName newDn = new LdapName(req.getName());
                newDn.remove(newDn.size() - 1);
                newDn.add(req.getNewRdn());
                ctx.rename(new LdapName(req.getName()), newDn);
            }
        }
        catch (NamingException e) {
            String msg = "failed to add entry " + req.getName() + ":\n";
            msg = msg + ExceptionUtils.getStackTrace(e);
            ResultCodeEnum code = e instanceof LdapException ? ((LdapException)((Object)e)).getResultCode() : ResultCodeEnum.getBestEstimate(e, req.getType());
            resp.getLdapResult().setResultCode(code);
            resp.getLdapResult().setErrorMessage(msg);
            if (e.getResolvedName() != null) {
                resp.getLdapResult().setMatchedDn(e.getResolvedName().toString());
            }
            session.write(resp);
            return;
        }
        resp.getLdapResult().setResultCode(ResultCodeEnum.SUCCESS);
        resp.getLdapResult().setMatchedDn(req.getName());
        session.write(resp);
    }
}

