/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.protocol.filter;

import java.util.logging.Level;
import org.apache.mina.common.IdleStatus;
import org.apache.mina.protocol.ProtocolFilter;
import org.apache.mina.protocol.ProtocolSession;
import org.apache.mina.util.SessionLog;

public class ProtocolLoggingFilter
implements ProtocolFilter {
    public static final String PREFIX = SessionLog.PREFIX;
    public static final String LOGGER = SessionLog.LOGGER;
    private Level defaultLevel = Level.INFO;

    public Level getDefaultLevel() {
        return this.defaultLevel;
    }

    public void setDefaultLevel(Level defaultLevel) {
        if (defaultLevel == null) {
            defaultLevel = Level.INFO;
        }
        this.defaultLevel = defaultLevel;
    }

    public void sessionOpened(ProtocolFilter.NextFilter nextFilter, ProtocolSession session) {
        SessionLog.log(this.defaultLevel, session, "OPENED");
        nextFilter.sessionOpened(session);
    }

    public void sessionClosed(ProtocolFilter.NextFilter nextFilter, ProtocolSession session) {
        SessionLog.log(this.defaultLevel, session, "CLOSED");
        nextFilter.sessionClosed(session);
    }

    public void sessionIdle(ProtocolFilter.NextFilter nextFilter, ProtocolSession session, IdleStatus status) {
        SessionLog.log(this.defaultLevel, session, "IDLE: " + status);
        nextFilter.sessionIdle(session, status);
    }

    public void exceptionCaught(ProtocolFilter.NextFilter nextFilter, ProtocolSession session, Throwable cause) {
        SessionLog.log(this.defaultLevel, session, "EXCEPTION:", cause);
        nextFilter.exceptionCaught(session, cause);
    }

    public void messageReceived(ProtocolFilter.NextFilter nextFilter, ProtocolSession session, Object message) {
        SessionLog.log(this.defaultLevel, session, "RECEIVED: " + message);
        nextFilter.messageReceived(session, message);
    }

    public void messageSent(ProtocolFilter.NextFilter nextFilter, ProtocolSession session, Object message) {
        SessionLog.log(this.defaultLevel, session, "SENT: " + message);
        nextFilter.messageSent(session, message);
    }

    public void filterWrite(ProtocolFilter.NextFilter nextFilter, ProtocolSession session, Object message) {
        SessionLog.log(this.defaultLevel, session, "WRITE: " + message);
        nextFilter.filterWrite(session, message);
    }
}

