/*
 * Decompiled with CFR 0.152.
 */
package EDU.purdue.jtb;

import EDU.purdue.jtb.InvalidCommandLineException;
import EDU.purdue.jtb.misc.Errors;
import EDU.purdue.jtb.misc.FileExistsException;
import EDU.purdue.jtb.misc.FileGenerator;
import EDU.purdue.jtb.misc.Globals;
import EDU.purdue.jtb.misc.NoArguFileGenerator;
import EDU.purdue.jtb.misc.OldFileGenerator;
import EDU.purdue.jtb.misc.VoidFileGenerator;
import EDU.purdue.jtb.misc.toolkit.GJDepthFirstVisitorBuilder;
import EDU.purdue.jtb.misc.toolkit.GJNoArguDepthFirstBuilder;
import EDU.purdue.jtb.misc.toolkit.GJVoidDepthFirstBuilder;
import EDU.purdue.jtb.misc.toolkit.OldDepthFirstVisitorBuilder;
import EDU.purdue.jtb.misc.toolkit.SchemeRecordBuilder;
import EDU.purdue.jtb.misc.toolkit.SchemeSemanticChecker;
import EDU.purdue.jtb.misc.toolkit.SchemeVisitorBuilder;
import EDU.purdue.jtb.misc.toolkit.TreeDumperBuilder;
import EDU.purdue.jtb.misc.toolkit.TreeFormatterBuilder;
import EDU.purdue.jtb.parser.JTBParser;
import EDU.purdue.jtb.parser.ParseException;
import EDU.purdue.jtb.syntaxtree.JavaCCInput;
import EDU.purdue.jtb.visitor.Annotator;
import EDU.purdue.jtb.visitor.ClassGenerator;
import EDU.purdue.jtb.visitor.Printer;
import EDU.purdue.jtb.visitor.SemanticChecker;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Vector;

public class JTB {
    private static InputStream in;
    private static String progName;
    private static String version;
    private static String scriptName;

    public static void main(String[] args) {
        block49: {
            try {
                if (!JTB.processCommandLine(args)) {
                    return;
                }
            }
            catch (InvalidCommandLineException e) {
                System.err.println(progName + ":  " + e.getMessage());
                return;
            }
            catch (Exception e) {
                Errors.hardErr(e.getMessage());
            }
            System.err.println(progName + " version " + version);
            System.err.println(progName + ":  Reading from " + Globals.inFilename + "...");
            JTBParser parser = new JTBParser(in);
            try {
                JavaCCInput root = parser.JavaCCInput();
                System.err.println(progName + ":  Input file parsed successfully.");
                ClassGenerator vcg = new ClassGenerator();
                FileGenerator gen = null;
                Errors.resetCounts();
                if (!Globals.noSemanticCheck) {
                    root.accept(new SemanticChecker());
                    if (Errors.errorCount() > 0) {
                        Errors.printSummary();
                        return;
                    }
                }
                root.accept(vcg);
                Vector list = vcg.getClassList();
                if (Errors.errorCount() > 0) {
                    Errors.printSummary();
                    return;
                }
                if (Globals.printGrammarToOut) {
                    root.accept(new Printer(System.out));
                }
                if (Globals.printClassList) {
                    gen = new FileGenerator(list);
                    System.out.println("\nThe classes generated and the fields each contains are as follows:\n");
                    gen.printClassList(new PrintWriter(System.out, true));
                }
                if (!Globals.generateFiles) break block49;
                try {
                    root.accept(new Annotator());
                    if (Errors.errorCount() > 0) {
                        Errors.printSummary();
                        return;
                    }
                    System.err.println(progName + ":  \"" + Globals.outFilename + "\" generated to current directory.");
                }
                catch (FileExistsException e) {
                    System.err.println(progName + ":  \"" + Globals.outFilename + "\" already exists.  Won't overwrite.");
                }
                if (gen == null) {
                    gen = new FileGenerator(list);
                    if (Errors.errorCount() > 0) {
                        Errors.printSummary();
                        return;
                    }
                }
                try {
                    gen.generateAutoClassFiles();
                }
                catch (FileExistsException e) {
                    System.err.println(progName + ":  One or more of the automatic " + "node class files already exists.  Won't overwrite.");
                }
                try {
                    gen.generateClassFiles();
                    System.err.println(progName + ":  Syntax tree Java source " + "files generated to directory \"" + Globals.nodeDir + "\".");
                }
                catch (FileExistsException e) {
                    System.err.println(progName + ":  One or more of the generated " + "node class files already exists.  Won't overwrite.");
                }
                System.err.println();
                try {
                    gen.generateVisitorFile();
                    System.err.println(progName + ":  \"" + "GJVisitor" + ".java\" generated " + "to directory \"" + Globals.visitorDir + "\".");
                }
                catch (FileExistsException e) {
                    System.err.println(progName + ":  \"" + "GJVisitor" + "\" already exists.  Won't overwrite.");
                }
                try {
                    new OldFileGenerator(list).generateVisitorFile();
                    System.err.println(progName + ":  \"" + "Visitor" + ".java\" generated " + "to directory \"" + Globals.visitorDir + "\".");
                }
                catch (FileExistsException e) {
                    System.err.println(progName + ":  \"" + "Visitor" + "\" already exists.  Won't overwrite.");
                }
                try {
                    new NoArguFileGenerator(list).generateVisitorFile();
                    System.err.println(progName + ":  \"" + "GJNoArguVisitor" + ".java\" generated " + "to directory \"" + Globals.visitorDir + "\".");
                }
                catch (FileExistsException e) {
                    System.err.println(progName + ":  \"" + "GJNoArguVisitor" + "\" already exists.  Won't overwrite.");
                }
                try {
                    new VoidFileGenerator(list).generateVisitorFile();
                    System.err.println(progName + ":  \"" + "GJVoidVisitor" + ".java\" generated " + "to directory \"" + Globals.visitorDir + "\".");
                }
                catch (FileExistsException e) {
                    System.err.println(progName + ":  \"" + "GJVoidVisitor" + "\" already exists.  Won't overwrite.");
                }
                try {
                    new GJDepthFirstVisitorBuilder(list).generateDepthFirstVisitor();
                    System.err.println(progName + ":  \"" + "GJDepthFirst.java" + "\" " + "generated to directory \"" + Globals.visitorDir + "\".");
                }
                catch (FileExistsException e) {
                    System.err.println(progName + ":  \"" + "GJDepthFirst.java" + "\" already exists.  " + "Won't overwrite.");
                }
                try {
                    new OldDepthFirstVisitorBuilder(list).generateDepthFirstVisitor();
                    System.err.println(progName + ":  \"" + "DepthFirstVisitor.java" + "\" " + "generated to directory \"" + Globals.visitorDir + "\".");
                }
                catch (FileExistsException e) {
                    System.err.println(progName + ":  \"" + "DepthFirstVisitor.java" + "\" already exists.  " + "Won't overwrite.");
                }
                try {
                    new GJNoArguDepthFirstBuilder(list).generateDepthFirstVisitor();
                    System.err.println(progName + ":  \"" + "GJNoArguDepthFirst.java" + "\" " + "generated to directory \"" + Globals.visitorDir + "\".");
                }
                catch (FileExistsException e) {
                    System.err.println(progName + ":  \"" + "GJNoArguDepthFirst.java" + "\" already exists.  " + "Won't overwrite.");
                }
                try {
                    new GJVoidDepthFirstBuilder(list).generateDepthFirstVisitor();
                    System.err.println(progName + ":  \"" + "GJVoidDepthFirst.java" + "\" " + "generated to directory \"" + Globals.visitorDir + "\".");
                }
                catch (FileExistsException e) {
                    System.err.println(progName + ":  \"" + "GJDepthFirst.java" + "\" already exists.  " + "Won't overwrite.");
                }
                System.err.println();
                if (Globals.schemeToolkit) {
                    root.accept(new SchemeSemanticChecker());
                    if (Errors.errorCount() > 0) {
                        Errors.printSummary();
                        return;
                    }
                    try {
                        new SchemeVisitorBuilder(list).generateSchemeBuilder();
                        System.err.println(progName + ":  \"" + "SchemeTreeBuilder.java" + "\" generated to " + "directory \"" + Globals.visitorDir + "\".");
                    }
                    catch (FileExistsException e) {
                        System.err.println(progName + ":  \"" + "SchemeTreeBuilder.java" + "\" already exists.  " + "Won't overwrite.");
                    }
                    try {
                        new SchemeRecordBuilder(list).generateSchemeRecords();
                        System.err.println(progName + ":  \"" + "records.scm" + "\" generated to " + "current directory.");
                    }
                    catch (FileExistsException e) {
                        System.err.println(progName + ":  \"" + "records.scm" + "\" already exists.  " + "Won't overwrite.");
                    }
                    System.err.println();
                }
                if (Globals.printerToolkit) {
                    try {
                        new TreeDumperBuilder().generateTreeDumper();
                        System.err.println(progName + ":  \"" + "TreeDumper.java" + "\" generated to " + "directory \"" + Globals.visitorDir + "\".");
                    }
                    catch (FileExistsException e) {
                        System.err.println(progName + ":  \"" + "TreeDumper.java" + "\" already exists.  " + "Won't overwrite.");
                    }
                    try {
                        new TreeFormatterBuilder(list).generateTreeFormatter();
                        System.err.println(progName + ":  \"" + "TreeFormatter.java" + "\" generated to " + "directory \"" + Globals.visitorDir + "\".");
                    }
                    catch (FileExistsException e) {
                        System.err.println(progName + ":  \"" + "TreeFormatter.java" + "\" already exists.  " + "Won't overwrite.");
                    }
                    System.err.println();
                }
                if (Errors.errorCount() > 0 || Errors.warningCount() > 0) {
                    Errors.printSummary();
                }
            }
            catch (ParseException e) {
                System.err.println("\n" + e.getMessage() + "\n");
                System.err.println(progName + ":  Encountered errors during " + "parse.");
            }
            catch (Exception e) {
                Errors.hardErr(e);
            }
        }
    }

    private static boolean processCommandLine(String[] args) throws InvalidCommandLineException {
        boolean returnVal = false;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].charAt(0) != '-') {
                if (returnVal) {
                    returnVal = false;
                    break;
                }
                try {
                    in = new FileInputStream(args[i]);
                }
                catch (FileNotFoundException e) {
                    System.err.println(progName + ":  File \"" + args[i] + "\" not found.");
                    return false;
                }
                Globals.inFilename = args[i];
                returnVal = true;
                continue;
            }
            if (args[i].length() <= 1) {
                throw new InvalidCommandLineException("Unknown option \"" + args[i] + "\".  Try \"" + scriptName + " -h\" for more " + "information.");
            }
            if (args[i].equals("-h")) {
                returnVal = false;
                break;
            }
            if (args[i].equals("-o")) {
                if (++i >= args.length || args[i].charAt(0) == '-') {
                    throw new InvalidCommandLineException("Option \"-o\" must be followed by a filename.");
                }
                Globals.outFilename = args[i];
                continue;
            }
            if (args[i].equals("-np")) {
                if (++i >= args.length || args[i].charAt(0) == '-') {
                    throw new InvalidCommandLineException("Option \"-np\" must be followed by a package name.");
                }
                Globals.setNodePackage(args[i]);
                continue;
            }
            if (args[i].equals("-vp")) {
                if (++i >= args.length || args[i].charAt(0) == '-') {
                    throw new InvalidCommandLineException("Option \"-vp\" must be followed by a package name.");
                }
                Globals.setVisitorPackage(args[i]);
                continue;
            }
            if (args[i].equals("-p")) {
                if (++i >= args.length || args[i].charAt(0) == '-') {
                    throw new InvalidCommandLineException("Option \"-p\" must be followed by a package name.");
                }
                Globals.setNodePackage(args[i] + ".syntaxtree");
                Globals.setVisitorPackage(args[i] + ".visitor");
                continue;
            }
            if (args[i].equals("-si")) {
                in = System.in;
                Globals.inFilename = "standard input";
                returnVal = true;
                continue;
            }
            if (args[i].equals("-w")) {
                Globals.noOverwrite = true;
                continue;
            }
            if (args[i].equals("-e")) {
                Globals.noSemanticCheck = true;
                continue;
            }
            if (args[i].equals("-jd")) {
                Globals.javaDocComments = true;
                continue;
            }
            if (args[i].equals("-f")) {
                Globals.descriptiveFieldNames = true;
                continue;
            }
            if (args[i].equals("-ns")) {
                if (++i >= args.length || args[i].charAt(0) == '-') {
                    throw new InvalidCommandLineException("Option \"-ns\" must be followed by a class name.");
                }
                Globals.nodeSuperclass = args[i];
                continue;
            }
            if (args[i].equals("-pp")) {
                Globals.parentPointers = true;
                continue;
            }
            if (args[i].equals("-tk")) {
                Globals.keepSpecialTokens = true;
                continue;
            }
            if (args[i].equals("-scheme")) {
                Globals.schemeToolkit = true;
                continue;
            }
            if (args[i].equals("-printer")) {
                Globals.printerToolkit = true;
                continue;
            }
            if (args[i].equals("-cl")) {
                Globals.printClassList = true;
                continue;
            }
            if (args[i].equals("-no")) {
                Globals.generateFiles = false;
                continue;
            }
            if (args[i].equals("-g")) {
                Globals.printGrammarToOut = true;
                continue;
            }
            throw new InvalidCommandLineException("Unknown option \"" + args[i] + "\".  Try \"" + scriptName + " -h\" for more " + "information.");
        }
        if (returnVal) {
            return true;
        }
        JTB.printHelp();
        return false;
    }

    private static void printHelp() {
        System.out.print(progName + " version " + version + "\n" + "\n" + "Usage: " + scriptName + " [OPTIONS] " + "[inputfile]\n" + "\n" + "Standard options:\n" + "  -h          Displays this help message.\n" + "  -o NAME     Uses NAME as the filename for the annotated output grammar.\n" + "  -np NAME    Uses NAME as the package for the syntax tree nodes.\n" + "  -vp NAME    Uses NAME as the package for the default Visitor class.\n" + "  -p NAME     \"-p pkg\" is short for \"-np pkg.syntaxtree -vp pkg.visitor\"\n" + "  -si         Read from standard input rather than a file.\n" + "  -w          Do not overwrite existing files.\n" + "  -e          Suppress JTB semantic error checking.\n" + "  -jd         Generate JavaDoc-friendly comments in the nodes and visitor.\n" + "  -f          Use descriptive node class field names.\n" + "  -ns NAME    Uses NAME as the class which all node classes will extend.\n" + "  -pp         Generate parent pointers in all node classes.\n" + "  -tk         Generate special tokens into the tree.\n" + "\n" + "Toolkit options:\n" + "  -scheme     Generate: (1) Scheme records representing the grammar.\n" + "                        (2) A Scheme tree building visitor.\n" + "  -printer    Generate a syntax tree dumping visitor.\n" + "\n");
    }

    static {
        progName = "JTB";
        version = "1.3.2";
        scriptName = "jtb";
    }
}

