/*
	Copyright 2009 Anatol Gregory Mayen
	
	Licensed under the Apache License, Version 2.0 (the "License");
	you may not use this file except in compliance with the License. 
	You may obtain a copy of the License at 
	
	http://www.apache.org/licenses/LICENSE-2.0 
	
	Unless required by applicable law or agreed to in writing, software 
	distributed under the License is distributed on an "AS IS" BASIS, 
	WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
	See the License for the specific language governing permissions and 
	limitations under the License. 
*/
package eu.maydu.gwt.validation.client.exceptions;

/**
 * This exception declares an incorrect serialization format.
 * 
 * This means that the method that throwed this method expected a different
 * representation of the entity that should be deserialized. There is probably
 * something wrong with the syntax.
 * 
 * There are two sources that might trigger this exception:
 * <ol>
 * 	<li>Something polluted the serialized data</li>
 * 	<li>A bug in gwt-vl</li>
 * </ol>
 * 
 *  So the first should be the main source of problems. So double check the
 *  serialized data that is given to the method that throws this exception.
 *  Maybe it got messed up somehow.
 * 
 * @author Anatol Mayen
 *
 */
public class IncorrectSerializationFormatException extends RuntimeException {
	
	public IncorrectSerializationFormatException() {
		super();
	}
	
	public IncorrectSerializationFormatException(String msg) {
		super(msg);
	}

}
