/*
	Copyright 2009 Anatol Gregory Mayen
	
	Licensed under the Apache License, Version 2.0 (the "License");
	you may not use this file except in compliance with the License. 
	You may obtain a copy of the License at 
	
	http://www.apache.org/licenses/LICENSE-2.0 
	
	Unless required by applicable law or agreed to in writing, software 
	distributed under the License is distributed on an "AS IS" BASIS, 
	WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
	See the License for the specific language governing permissions and 
	limitations under the License. 
*/
package eu.maydu.gwt.validation.client.groupTransformers;

import com.google.gwt.user.client.ui.SuggestBox;
import com.google.gwt.user.client.ui.TextBoxBase;
import com.google.gwt.user.client.ui.Widget;

import eu.maydu.gwt.validation.client.GroupValidator;
import eu.maydu.gwt.validation.client.transformers.TrimTransformer;
import eu.maydu.gwt.validation.client.transformers.UpperCaseTransformer;

public class TrimmedUpperCaseTransformer extends GroupValidator<TrimmedUpperCaseTransformer> {

	private TextBoxBase text;
	private SuggestBox suggest;

	
	public TrimmedUpperCaseTransformer(TextBoxBase text) {
		super(false);
		if(text == null)
			throw new IllegalArgumentException("text must not be null");
		setup(text);
	}
	
	public TrimmedUpperCaseTransformer(SuggestBox suggest) {
		super(false);
		if(text == null)
			throw new IllegalArgumentException("suggest must not be null");
		setup(suggest);
	}
	
	public TrimmedUpperCaseTransformer(boolean preventsExecution, TextBoxBase text) {
		super(preventsExecution);
		if(text == null)
			throw new IllegalArgumentException("text must not be null");
		setup(text);
	}
	
	public TrimmedUpperCaseTransformer(boolean preventsExecution, SuggestBox suggest) {
		super(preventsExecution);
		if(text == null)
			throw new IllegalArgumentException("suggest must not be null");
		setup(suggest);
	}
	
	
	private void setup(Widget w) {
		if(w instanceof TextBoxBase) {
			text = (TextBoxBase) w;
			addValidators(
				new TrimTransformer(text),
				new UpperCaseTransformer(text)
			);
		}else {
			suggest = (SuggestBox) w;
			addValidators(
					new TrimTransformer(suggest),
					new UpperCaseTransformer(suggest)
			);
		}
	}

	
	
}
