/*
	Copyright 2009 Anatol Gregory Mayen
	
	Licensed under the Apache License, Version 2.0 (the "License");
	you may not use this file except in compliance with the License. 
	You may obtain a copy of the License at 
	
	http://www.apache.org/licenses/LICENSE-2.0 
	
	Unless required by applicable law or agreed to in writing, software 
	distributed under the License is distributed on an "AS IS" BASIS, 
	WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
	See the License for the specific language governing permissions and 
	limitations under the License. 
*/
package eu.maydu.gwt.validation.client.showcase;

import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;

/**
 * 
 * @author Anatol Mayen
 *
 */
public class FormLayoutPanel extends VerticalPanel {
	
	
	private GridPanel gridPanel;

	public FormLayoutPanel() {
		gridPanel = new GridPanel();
	}
	
	
	public FormLayoutPanel add(Widget widget, boolean required) {
		return add(null, widget, required, 1, 1);
	}
	
	public FormLayoutPanel add(Widget widget, boolean required, int rowSpan, int colSpan) {
		return add(null, widget, required, rowSpan, colSpan);
	}
	
	public FormLayoutPanel add(String label, Widget widget, boolean required) {
		return add(label, widget, required, 1, 1);
	}
	
	public FormLayoutPanel add(String label, Widget widget, boolean required, int rowSpan, int colSpan) {
		Label l = null;
		if(label != null)
			l = new Label(label+":");
		Label requiredLabel = new Label(required?"*":"");
		if(label != null)
			gridPanel.addWidget(l);
		gridPanel.addWidget(widget, rowSpan, colSpan).addWidget(requiredLabel);
		return this;
	}
	
	public FormLayoutPanel addDelimiter(Widget widget) {
		return addDelimiter(widget, 1, 1);
	}
	
	public FormLayoutPanel addDelimiter(Widget widget, int rowSpan, int colSpan) {
		gridPanel.addWidget(widget, rowSpan, colSpan);
		return this;
	}

	public FormLayoutPanel addDelimiter(String label) {
		return addDelimiter(label, 1, 1);
	}
	
	public FormLayoutPanel addDelimiter(String label, int rowSpan, int colSpan) {
		Label delimiterLabel = new Label(label);
		gridPanel.addWidget(delimiterLabel, rowSpan, colSpan);
		return this;
	}
	
	public FormLayoutPanel newRow() {
		gridPanel.addRow();
		return this;
	}
	
	public void create() {
		add(gridPanel.create());
	}
 
}