/*
	Copyright 2009 Anatol Gregory Mayen
	
	Licensed under the Apache License, Version 2.0 (the "License");
	you may not use this file except in compliance with the License. 
	You may obtain a copy of the License at 
	
	http://www.apache.org/licenses/LICENSE-2.0 
	
	Unless required by applicable law or agreed to in writing, software 
	distributed under the License is distributed on an "AS IS" BASIS, 
	WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
	See the License for the specific language governing permissions and 
	limitations under the License. 
*/
package eu.maydu.gwt.validation.client.validators.strings;

import com.google.gwt.user.client.ui.SuggestBox;
import com.google.gwt.user.client.ui.TextBox;

import eu.maydu.gwt.validation.client.ValidationAction;
import eu.maydu.gwt.validation.client.ValidationResult;
import eu.maydu.gwt.validation.client.Validator;
import eu.maydu.gwt.validation.client.i18n.ValidationMessages;
import eu.maydu.gwt.validation.client.validators.ValidatorAlgorithmResult;
import eu.maydu.gwt.validation.client.validators.strings.algorithms.EmailValidatorAlgorithm;

public class EmailValidator extends Validator<EmailValidator>{

	private TextBox textBox;
	private SuggestBox suggestBox;
	private EmailValidatorAlgorithm algorithm = new EmailValidatorAlgorithm();
	
	public EmailValidator(TextBox textBox) {
		this.textBox = textBox;
	}
	
	public EmailValidator(SuggestBox suggestBox) {
		this.suggestBox = suggestBox;
	}
	
	
	@Override
	public void invokeActions(ValidationResult result) {
		if(textBox != null) {
			for(ValidationAction<TextBox> va : getFailureActions()) {
				va.invoke(result, textBox);
			}
		}else {
			for(ValidationAction<SuggestBox> va : getFailureActions()) {
				va.invoke(result, suggestBox);
			}
		}
		
	}

	@Override
	public <V extends ValidationMessages> ValidationResult validate(V messages) {
		String input = getInput();
		if(!isRequired() && input.equals(""))
			return null;
		
		ValidatorAlgorithmResult result = algorithm.validate(input);
		
		if(result == null)
			return null;
		
		return new ValidationResult(getErrorMessage(messages, messages.getStandardMessages().notAValidEmail((String)result.getParameters()[0]), result.getParameters()));
	}

	private String getInput() {
		if(textBox != null)
			return textBox.getText();
		else
			return suggestBox.getText();
	}

}
