/*
 * Decompiled with CFR 0.152.
 */
package eu.stamp_project.descartes.codemanipulation;

import java.util.Set;
import java.util.stream.Stream;
import org.pitest.reloc.asm.Type;

public abstract class ElementInfo {
    protected int access;
    protected String name;
    protected String signature;

    public ElementInfo(int access, String name, String signature) {
        this.access = access;
        this.name = name;
        this.signature = signature;
    }

    public String getName() {
        return this.name;
    }

    public String getSignature() {
        return this.signature;
    }

    public boolean hasFlag(int flag) {
        return (this.access & flag) != 0;
    }

    protected Type[] toTypes(String[] typeNames) {
        if (typeNames == null || typeNames.length == 0) {
            return new Type[0];
        }
        return (Type[])Stream.of(typeNames).map(Type::getObjectType).toArray(Type[]::new);
    }

    protected Set<Type> toTypeSet(String[] typeNames) {
        return Set.of(this.toTypes(typeNames));
    }

    public boolean isStatic() {
        return this.hasFlag(8);
    }

    public boolean isAbstract() {
        return this.hasFlag(1024);
    }
}

