/*
 * Decompiled with CFR 0.152.
 */
package eu.stamp_project.descartes.operators;

import eu.stamp_project.descartes.annotations.Operator;
import eu.stamp_project.descartes.codemanipulation.MethodInfo;
import eu.stamp_project.descartes.operators.MutationOperator;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import org.pitest.reloc.asm.Type;
import org.pitest.reloc.asm.commons.GeneratorAdapter;

@Operator(identifier="new", description="Method body replaced by instructions to return an instance of the class using a constructor with no parameters")
public class NewInstanceMutationOperator
extends MutationOperator {
    private static final Map<Class<?>, Class<?>> ALTERNATIVE_RETURN_CLASS_BY_TYPE = new HashMap();

    @Override
    public boolean canMutate(MethodInfo method) {
        try {
            Class<?> returnClass = NewInstanceMutationOperator.getAppropriateReturnClass(method);
            if (returnClass.equals(String.class) || !this.belongsToJavaPackages(returnClass) || Modifier.isAbstract(returnClass.getModifiers())) {
                return false;
            }
            for (Constructor<?> publicConstructor : returnClass.getConstructors()) {
                if (publicConstructor.getParameters().length != 0) continue;
                return true;
            }
            return false;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private boolean belongsToJavaPackages(Class<?> aClass) {
        Package classPackage = aClass.getPackage();
        if (classPackage == null) {
            return false;
        }
        String[] nameParts = classPackage.getName().split("\\.");
        return nameParts.length >= 1 && nameParts[0].equals("java");
    }

    protected static Class<?> getAppropriateReturnClass(MethodInfo method) throws ClassNotFoundException {
        return NewInstanceMutationOperator.getAppropriateReturnClass(method.getReturnType().getClassName());
    }

    protected static Class<?> getAppropriateReturnClass(String className) throws ClassNotFoundException {
        Class<?> originalClass = Class.forName(className);
        if (ALTERNATIVE_RETURN_CLASS_BY_TYPE.containsKey(originalClass)) {
            return ALTERNATIVE_RETURN_CLASS_BY_TYPE.get(originalClass);
        }
        return originalClass;
    }

    @Override
    protected void generateCode(MethodInfo method, GeneratorAdapter mv) {
        Class<?> appropriateReturnClass = null;
        try {
            appropriateReturnClass = NewInstanceMutationOperator.getAppropriateReturnClass(method);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
        Type appropriateReturnType = Type.getType(appropriateReturnClass);
        mv.visitTypeInsn(187, appropriateReturnType.getInternalName());
        mv.visitInsn(89);
        mv.visitMethodInsn(183, appropriateReturnType.getInternalName(), "<init>", "()V", false);
        mv.visitInsn(176);
    }

    static {
        ALTERNATIVE_RETURN_CLASS_BY_TYPE.put(Collection.class, ArrayList.class);
        ALTERNATIVE_RETURN_CLASS_BY_TYPE.put(Iterable.class, ArrayList.class);
        ALTERNATIVE_RETURN_CLASS_BY_TYPE.put(List.class, ArrayList.class);
        ALTERNATIVE_RETURN_CLASS_BY_TYPE.put(Queue.class, LinkedList.class);
        ALTERNATIVE_RETURN_CLASS_BY_TYPE.put(Set.class, HashSet.class);
        ALTERNATIVE_RETURN_CLASS_BY_TYPE.put(Map.class, HashMap.class);
    }
}

