/*
 * Decompiled with CFR 0.152.
 */
package eu.stamp_project.descartes.operators.parsing;

import eu.stamp_project.descartes.operators.parsing.LiteralLexer;
import eu.stamp_project.descartes.operators.parsing.Token;
import eu.stamp_project.descartes.operators.parsing.TokenType;
import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.NoSuchElementException;
import java.util.Objects;

public class LiteralParser {
    private Token lookahead;
    private LiteralLexer lexer;

    public Result parse(String line) {
        if (LiteralParser.isNullOrBlank(line)) {
            return Result.error("Input is null or blank");
        }
        try {
            this.lexer = new LiteralLexer(new StringReader(line));
            Result result = null;
            this.next();
            if (this.lookahead.is(266240)) {
                result = Result.ok(Character.valueOf(this.lookahead.getLexeme().charAt(0)));
            } else if (this.lookahead.is(270336)) {
                result = Result.ok(this.lookahead.getLexeme());
            } else if (this.lookahead.is(278528)) {
                result = Result.ok(Boolean.valueOf(this.lookahead.getLexeme()));
            } else if (this.lookahead.is(294912)) {
                result = Result.ok(this.tokenToNumber(this.lookahead));
            } else if (this.lookahead.is(65537)) {
                result = this.negativeNumericLiteral();
            } else if (this.lookahead.is(65538)) {
                result = this.byteOrShortLiteral();
            }
            if (result == null) {
                return Result.error("Invalid literal notation");
            }
            if (!result.hasError()) {
                this.next();
                if (!this.lookahead.is(0x100000)) {
                    result = Result.error("End of line expected.");
                }
            }
            return result;
        }
        catch (Exception exc) {
            return Result.error("Unexpected exception " + exc);
        }
    }

    private Result negativeNumericLiteral() throws IOException {
        this.next();
        if (this.lookahead.is(294912)) {
            return Result.ok(this.tokenToNumber(new Token(this.lookahead.getType(), "-" + this.lookahead.getLexeme())));
        }
        return Result.error("Expecting numeric literal after minus sign.");
    }

    private Result byteOrShortLiteral() throws IOException {
        this.next();
        if (!this.lookahead.is(131072)) {
            return Result.error("Expecting type names byte or short, got: " + this.lookahead.getLexeme());
        }
        int resultType = this.lookahead.getType();
        String prefix = "";
        this.next();
        if (!this.lookahead.is(65540)) {
            return Result.error("Expecting right parenthesis, got: " + this.lookahead.getLexeme());
        }
        this.next();
        if (this.lookahead.is(65537)) {
            prefix = "-";
            this.next();
        }
        if (!this.lookahead.is(296960)) {
            return Result.error("Expecting an integral literal, got: " + this.lookahead.getLexeme());
        }
        return Result.ok(this.tokenToNumber(new Token(TokenType.typeToLiteral(resultType) | TokenType.getRadix(this.lookahead.getType()), prefix + this.lookahead.getLexeme())));
    }

    public void next() throws IOException {
        this.lookahead = this.lexer.nextToken();
    }

    private Object tokenToNumber(Token token) {
        Class<?> numericType = TokenType.getNumericType(token.getType());
        if (token.is(296960)) {
            return this.integerValueOf(numericType, token.getLexeme(), TokenType.getRadix(token.getType()));
        }
        return this.valueOf(numericType, token.getLexeme());
    }

    private Object valueOf(Class<?> type, String value) {
        try {
            Method method = type.getDeclaredMethod("valueOf", String.class);
            return method.invoke(null, value);
        }
        catch (IllegalAccessException | NoSuchMethodException exc) {
            throw new AssertionError((Object)("Class " + type.getName() + " expected to have an accessible valueOf(String) method"));
        }
        catch (InvocationTargetException exc) {
            throw new IllegalArgumentException("Error while obtaining value of type " + type.getName() + " from string " + value, exc);
        }
    }

    private Object integerValueOf(Class<?> type, String value, int radix) {
        try {
            Method method = type.getDeclaredMethod("valueOf", String.class, Integer.TYPE);
            return method.invoke(null, value, radix);
        }
        catch (IllegalAccessException | NoSuchMethodException exc) {
            throw new AssertionError((Object)("Class " + type.getName() + " expected to have an accessible valueOf(String, int) method"));
        }
        catch (InvocationTargetException exc) {
            throw new IllegalArgumentException("Error while obtaining value of type " + type.getName() + " from string " + value + " using radix " + radix, exc);
        }
    }

    private static boolean isNullOrBlank(String str) {
        return str == null || str.trim().isEmpty();
    }

    public static class Result {
        private final Object value;
        private final String error;

        private Result(Object value, String error) {
            this.value = value;
            this.error = error;
        }

        public static Result ok(Object value) {
            Objects.requireNonNull(value, "Value can not be null in successful parsing result");
            return new Result(value, null);
        }

        public static Result error(String error) {
            if (LiteralParser.isNullOrBlank(error)) {
                throw new IllegalArgumentException("Resulting error message can not be null, empty or blank.");
            }
            return new Result(null, error);
        }

        public boolean hasError() {
            return this.error != null;
        }

        public Object getValue() {
            if (this.hasError()) {
                throw new NoSuchElementException("Parsing resulted in error. No value was produced.");
            }
            return this.value;
        }

        public String getError() {
            return this.hasError() ? this.error : null;
        }
    }
}

