/*
 * Decompiled with CFR 0.152.
 */
package eu.stamp_project.descartes.reporting;

import eu.stamp_project.descartes.reporting.models.MethodRecord;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;
import org.pitest.mutationtest.ClassMutationResults;
import org.pitest.mutationtest.ListenerArguments;
import org.pitest.mutationtest.MutationResultListener;
import org.pitest.util.Unchecked;

public class IssuesReportListener
implements MutationResultListener {
    private ListenerArguments arguments;
    private VelocityEngine engine;
    private Template methodResportTemplate;
    private Template indexTemplate;
    private List<ClassIssues> findings;

    public IssuesReportListener(ListenerArguments arguments) {
        this.arguments = arguments;
    }

    public void runStart() {
        VelocityEngine engine = new VelocityEngine();
        engine.setProperty("resource.loader", (Object)"classpath");
        engine.setProperty("classpath.resource.loader.class", (Object)ClasspathResourceLoader.class.getName());
        engine.init();
        this.methodResportTemplate = engine.getTemplate("templates/method-report.vm", "UTF-8");
        this.indexTemplate = engine.getTemplate("templates/index-report.vm", "UTF-8");
        this.findings = new ArrayList<ClassIssues>();
    }

    private Writer createFile(String path) {
        String filePath = Paths.get("issues", path).toString();
        return this.arguments.getOutputStrategy().createWriterForFile(filePath);
    }

    public void handleMutationResult(ClassMutationResults classMutationResults) {
        MethodRecord[] issues = (MethodRecord[])MethodRecord.getRecords(classMutationResults).filter(MethodRecord::hasIssues).toArray(MethodRecord[]::new);
        if (issues.length == 0) {
            return;
        }
        String className = classMutationResults.getMutatedClass().asJavaName();
        VelocityContext context = new VelocityContext();
        context.put("className", (Object)className);
        context.put("issues", (Object)issues);
        try (Writer writer = this.createFile(className + ".html");){
            this.methodResportTemplate.merge((Context)context, writer);
        }
        catch (IOException exc) {
            throw Unchecked.translateCheckedException((String)("Could not write file for class: " + className), (Throwable)exc);
        }
        this.findings.add(new ClassIssues(className, issues.length));
    }

    private String getStringTime() {
        Duration elapsed = Duration.ofMillis(System.currentTimeMillis() - this.arguments.getStartTime());
        String[] units = new String[]{"day", "hour", "minute", "second"};
        long[] parts = new long[]{elapsed.toDays(), elapsed.toHours() % 24L, elapsed.toMinutes() % 60L, elapsed.getSeconds() % 60L};
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < parts.length; ++i) {
            if (parts[i] == 0L) continue;
            result.append(parts[i]).append(" ").append(units[i]);
            if (parts[i] > 1L) {
                result.append("s");
            }
            result.append(" ");
        }
        if (result.length() == 0) {
            return "less than one second";
        }
        return result.substring(0, result.length() - 1);
    }

    public void runEnd() {
        VelocityContext context = new VelocityContext();
        context.put("duration", (Object)this.getStringTime());
        context.put("total", (Object)this.findings.stream().mapToInt(ClassIssues::getIssues).sum());
        context.put("findings", this.findings);
        context.put("operators", (Object)this.arguments.getEngine().getMutatorNames());
        try (Writer writer = this.createFile("index.html");){
            this.indexTemplate.merge((Context)context, writer);
        }
        catch (IOException exc) {
            throw Unchecked.translateCheckedException((String)"Could not write report index file", (Throwable)exc);
        }
    }

    public static class ClassIssues {
        private String className;
        private int issues;

        public ClassIssues(String className, int issues) {
            this.className = className;
            this.issues = issues;
        }

        public String getClassName() {
            return this.className;
        }

        public int getIssues() {
            return this.issues;
        }
    }
}

