/*
 * Decompiled with CFR 0.152.
 */
package eu.stamp_project.descartes.reporting.models;

import eu.stamp_project.descartes.reporting.models.MethodClassification;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.objectweb.asm.signature.SignatureReader;
import org.objectweb.asm.signature.SignatureVisitor;
import org.objectweb.asm.util.TraceSignatureVisitor;
import org.pitest.coverage.TestInfo;
import org.pitest.mutationtest.ClassMutationResults;
import org.pitest.mutationtest.DetectionStatus;
import org.pitest.mutationtest.MutationResult;
import org.pitest.mutationtest.engine.Location;

public class MethodRecord {
    private Location location;
    private MethodClassification classification;
    private Set<MutationResult> mutationResults = new HashSet<MutationResult>();
    private String fileName;
    private int lineNumber;

    public MethodRecord(MutationResult mutation) {
        this.initialize(mutation);
    }

    public MethodRecord(MutationResult ... mutations) {
        if (mutations == null || mutations.length == 0) {
            throw new IllegalArgumentException("At least one mutation result must be provided.");
        }
        this.initialize(mutations[0]);
        for (int i = 0; i < mutations.length; ++i) {
            this.add(mutations[i]);
        }
    }

    public MethodRecord(Collection<MutationResult> mutations) {
        this(MethodRecord.toArray(mutations));
    }

    public MethodRecord(Stream<MutationResult> mutations) {
        this(mutations.collect(Collectors.toList()));
    }

    private MethodClassification statusToClassification(DetectionStatus status) {
        if (status.isDetected()) {
            return MethodClassification.TESTED;
        }
        if (status == DetectionStatus.NO_COVERAGE) {
            return MethodClassification.NOT_COVERED;
        }
        return MethodClassification.PSEUDO_TESTED;
    }

    private static MutationResult[] toArray(Collection<MutationResult> mutationResults) {
        MutationResult[] results = new MutationResult[mutationResults.size()];
        mutationResults.toArray(results);
        return results;
    }

    private void initialize(MutationResult mutation) {
        this.mutationResults.add(mutation);
        this.location = mutation.getDetails().getId().getLocation();
        this.classification = this.statusToClassification(mutation.getStatus());
        this.fileName = mutation.getDetails().getFilename();
        this.lineNumber = mutation.getDetails().getLineNumber();
    }

    private void updateStatus(DetectionStatus status) {
        if (status == DetectionStatus.NO_COVERAGE) {
            if (this.classification != MethodClassification.NOT_COVERED) {
                throw new IllegalArgumentException("Method " + this.location.getMethodName() + " has been marked as covered and can not accept a non-covered mutation.");
            }
            return;
        }
        if (this.classification == MethodClassification.NOT_COVERED) {
            throw new IllegalArgumentException("Method " + this.location.getMethodName() + " has been marked as non-covered and can not accept a covered mutation");
        }
        if (status.isDetected() && this.classification == MethodClassification.PSEUDO_TESTED || !status.isDetected() && this.classification == MethodClassification.TESTED) {
            this.classification = MethodClassification.PARTIALLY_TESTED;
        }
    }

    public void add(MutationResult mutation) {
        if (!mutation.getDetails().getId().getLocation().equals((Object)this.location)) {
            throw new IllegalArgumentException("All related mutations should be placed in the same location");
        }
        this.mutationResults.add(mutation);
        this.updateStatus(mutation.getStatus());
    }

    public MethodClassification getClassification() {
        return this.classification;
    }

    public Collection<TestInfo> getTests() {
        return this.mutationResults.stream().flatMap(mutation -> mutation.getDetails().getTestsInOrder().stream()).collect(Collectors.toSet());
    }

    public Collection<MutationResult> getMutations() {
        return Collections.unmodifiableSet(this.mutationResults);
    }

    public Collection<MutationResult> getDetectedMutations() {
        return this.mutationResults.stream().filter(mutation -> mutation.getStatus().isDetected()).collect(Collectors.toList());
    }

    public Collection<MutationResult> getUndetectedMutations() {
        return this.mutationResults.stream().filter(mutation -> !mutation.getStatus().isDetected()).collect(Collectors.toList());
    }

    public Location getLocation() {
        return this.location;
    }

    public String getName() {
        return this.location.getMethodName();
    }

    public String getDesc() {
        return this.location.getMethodDesc();
    }

    public String getClassName() {
        return this.location.getClassName().getNameWithoutPackage().asInternalName();
    }

    public String getPackageName() {
        return this.location.getClassName().getPackage().asInternalName();
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getDeclaration() {
        TraceSignatureVisitor visitor = new TraceSignatureVisitor(0);
        new SignatureReader(this.getDesc()).accept((SignatureVisitor)visitor);
        return this.getName() + visitor.getDeclaration();
    }

    public String getReturnType() {
        TraceSignatureVisitor visitor = new TraceSignatureVisitor(0);
        new SignatureReader(this.getDesc()).accept((SignatureVisitor)visitor);
        return visitor.getReturnType();
    }

    public boolean hasIssues() {
        return this.classification == MethodClassification.PSEUDO_TESTED || this.classification == MethodClassification.PARTIALLY_TESTED;
    }

    public boolean isVoid() {
        return this.getDesc().endsWith(")V");
    }

    public static String methodKey(MutationResult mutation) {
        String className = mutation.getDetails().getClassName().asJavaName();
        String methodName = mutation.getDetails().getMethod();
        String methodDescription = mutation.getDetails().getId().getLocation().getMethodDesc();
        return className + "." + methodName + methodDescription;
    }

    public static Stream<MethodRecord> getRecords(ClassMutationResults results) {
        return results.getMutations().stream().collect(Collectors.groupingBy(MethodRecord::methodKey)).values().stream().map(MethodRecord::new);
    }
}

