/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.applications.signerclient.crypto.jce;

import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.DigestInfo;
import org.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.encodings.PKCS1Encoding;
import org.bouncycastle.crypto.engines.RSAEngine;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.exoplatform.applications.signerclient.crypto.jce.EnclosingDigest;
import org.exoplatform.applications.signerclient.crypto.jce.RSAUtil;
import org.exoplatform.applications.signerclient.crypto.jce.Signer;

class RSASigner
implements PKCSObjectIdentifiers,
X509ObjectIdentifiers,
Signer {
    private String algorithm;
    private Digest digest;
    private AsymmetricBlockCipher cipher;
    private AlgorithmIdentifier algId;

    protected RSASigner(String algorithm, DERObjectIdentifier objId, Digest digest, AsymmetricBlockCipher cipher) {
        this.algorithm = algorithm;
        this.digest = digest;
        this.cipher = new PKCS1Encoding((AsymmetricBlockCipher)new RSAEngine());
        this.algId = new AlgorithmIdentifier(objId, null);
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void initVerify(PublicKey publicKey) throws InvalidKeyException {
        if (!(publicKey instanceof RSAPublicKey)) {
            throw new InvalidKeyException("Supplied key (" + this.getType(publicKey) + ") is not a RSAPublicKey instance");
        }
        RSAKeyParameters param = RSAUtil.generatePublicKeyParameter((RSAPublicKey)publicKey);
        this.digest.reset();
        this.cipher.init(false, (CipherParameters)param);
    }

    public void initSign(PrivateKey privateKey) throws InvalidKeyException {
        if (!(privateKey instanceof RSAPrivateKey)) {
            throw new InvalidKeyException("Supplied key (" + this.getType(privateKey) + ") is not a RSAPrivateKey instance");
        }
        RSAKeyParameters param = RSAUtil.generatePrivateKeyParameter((RSAPrivateKey)privateKey);
        this.digest.reset();
        this.cipher.init(true, (CipherParameters)param);
    }

    private String getType(Object o) {
        if (o == null) {
            return null;
        }
        return o.getClass().getName();
    }

    public byte[] sign() throws SignatureException {
        byte[] hash = new byte[this.digest.getDigestSize()];
        this.digest.doFinal(hash, 0);
        try {
            byte[] bytes = this.derEncode(hash);
            return this.cipher.processBlock(bytes, 0, bytes.length);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new SignatureException("key too small for signature type");
        }
        catch (Exception e) {
            throw new SignatureException(e.toString());
        }
    }

    public boolean verify(byte[] sigBytes) throws SignatureException {
        byte[] expected;
        byte[] sig;
        byte[] hash = new byte[this.digest.getDigestSize()];
        this.digest.doFinal(hash, 0);
        try {
            sig = this.cipher.processBlock(sigBytes, 0, sigBytes.length);
            expected = this.derEncode(hash);
        }
        catch (Exception e) {
            return false;
        }
        if (sig.length == expected.length) {
            for (int i = 0; i < sig.length; ++i) {
                if (sig[i] == expected[i]) continue;
                return false;
            }
        } else if (sig.length == expected.length - 2) {
            int i;
            int sigOffset = sig.length - hash.length - 2;
            int expectedOffset = expected.length - hash.length - 2;
            expected[1] = (byte)(expected[1] - 2);
            expected[3] = (byte)(expected[3] - 2);
            for (i = 0; i < hash.length; ++i) {
                if (sig[sigOffset + i] == expected[expectedOffset + i]) continue;
                return false;
            }
            for (i = 0; i < sigOffset; ++i) {
                if (sig[i] == expected[i]) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    private byte[] derEncode(byte[] hash) throws IOException {
        DigestInfo dInfo = new DigestInfo(this.algId, hash);
        return dInfo.getEncoded("DER");
    }

    public static class MD5WithRSAEncryption
    extends RSASigner {
        public MD5WithRSAEncryption(byte[] hash) {
            super("MD5withRSA", md5, new EnclosingDigest(hash, "MD5"), (AsymmetricBlockCipher)new PKCS1Encoding((AsymmetricBlockCipher)new RSAEngine()));
        }
    }

    public static class MD4WithRSAEncryption
    extends RSASigner {
        public MD4WithRSAEncryption(byte[] hash) {
            super("MD4withRSA", md4, new EnclosingDigest(hash, "MD4"), (AsymmetricBlockCipher)new PKCS1Encoding((AsymmetricBlockCipher)new RSAEngine()));
        }
    }

    public static class MD2WithRSAEncryption
    extends RSASigner {
        public MD2WithRSAEncryption(byte[] hash) {
            super("MD2withRSA", md2, new EnclosingDigest(hash, "MD2"), (AsymmetricBlockCipher)new PKCS1Encoding((AsymmetricBlockCipher)new RSAEngine()));
        }
    }

    public static class SHA512WithRSAEncryption
    extends RSASigner {
        public SHA512WithRSAEncryption(byte[] hash) {
            super("SHA512withRSA", NISTObjectIdentifiers.id_sha512, new EnclosingDigest(hash, "SHA512"), (AsymmetricBlockCipher)new PKCS1Encoding((AsymmetricBlockCipher)new RSAEngine()));
        }
    }

    public static class SHA384WithRSAEncryption
    extends RSASigner {
        public SHA384WithRSAEncryption(byte[] hash) {
            super("SHA384withRSA", NISTObjectIdentifiers.id_sha384, new EnclosingDigest(hash, "SHA384"), (AsymmetricBlockCipher)new PKCS1Encoding((AsymmetricBlockCipher)new RSAEngine()));
        }
    }

    public static class SHA256WithRSAEncryption
    extends RSASigner {
        public SHA256WithRSAEncryption(byte[] hash) {
            super("SHA256withRSA", NISTObjectIdentifiers.id_sha256, new EnclosingDigest(hash, "SHA256"), (AsymmetricBlockCipher)new PKCS1Encoding((AsymmetricBlockCipher)new RSAEngine()));
        }
    }

    public static class SHA224WithRSAEncryption
    extends RSASigner {
        public SHA224WithRSAEncryption(byte[] hash) {
            super("SHA224withRSA", NISTObjectIdentifiers.id_sha224, new EnclosingDigest(hash, "SHA224"), (AsymmetricBlockCipher)new PKCS1Encoding((AsymmetricBlockCipher)new RSAEngine()));
        }
    }

    public static class SHA1WithRSAEncryption
    extends RSASigner {
        public SHA1WithRSAEncryption(byte[] hash) {
            super("SHA1withRSA", id_SHA1, new EnclosingDigest(hash, "SHA1"), (AsymmetricBlockCipher)new PKCS1Encoding((AsymmetricBlockCipher)new RSAEngine()));
        }
    }
}

