/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.actions;

import java.util.HashMap;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.cms.actions.ActionServiceContainer;
import org.exoplatform.services.cms.actions.ECMEventListener;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.security.SecurityService;

public abstract class BaseActionLauncherListener
implements ECMEventListener {
    protected String actionName_;
    protected String srcWorkspace_;
    protected String srcPath_;
    protected String executable_;
    protected Map actionVariables_;

    public BaseActionLauncherListener(String actionName, String executable, String srcWorkspace, String srcPath, Map actionVariables) throws Exception {
        this.actionName_ = actionName;
        this.executable_ = executable;
        this.srcWorkspace_ = srcWorkspace;
        this.srcPath_ = srcPath;
        this.actionVariables_ = actionVariables;
    }

    public String getSrcWorkspace() {
        return this.srcWorkspace_;
    }

    public void onEvent(EventIterator events) {
        ExoContainer exoContainer = ExoContainerContext.getCurrentContainer();
        RepositoryService repositoryService = (RepositoryService)exoContainer.getComponentInstanceOfType(RepositoryService.class);
        TemplateService templateService = (TemplateService)exoContainer.getComponentInstanceOfType(TemplateService.class);
        ActionServiceContainer actionServiceContainer = (ActionServiceContainer)exoContainer.getComponentInstanceOfType(ActionServiceContainer.class);
        SecurityService securityService = (SecurityService)exoContainer.getComponentInstanceOfType(SecurityService.class);
        if (events.hasNext()) {
            Event event = events.nextEvent();
            Node node = null;
            String userId = event.getUserID();
            Session jcrSession = null;
            try {
                jcrSession = repositoryService.getRepository().getSystemSession(this.srcWorkspace_);
                node = (Node)jcrSession.getItem(this.srcPath_);
                Node actionNode = actionServiceContainer.getInitAction(node, this.actionName_);
                Property rolesProp = actionNode.getProperty("exo:roles");
                boolean hasPermission = false;
                Value[] roles = rolesProp.getValues();
                for (int i = 0; i < roles.length; ++i) {
                    String role = roles[i].getString();
                    if (!securityService.hasMembershipInGroup(userId, role) && !"__system".equals(userId)) continue;
                    hasPermission = true;
                    break;
                }
                if (!hasPermission) {
                    return;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
            try {
                String path = event.getPath();
                HashMap<String, String> variables = new HashMap<String, String>();
                variables.put("initiator", userId);
                variables.put("actionName", this.actionName_);
                variables.put("nodePath", path);
                variables.put("srcWorkspace", this.srcWorkspace_);
                variables.put("srcPath", this.srcPath_);
                variables.putAll(this.actionVariables_);
                if (event.getType() == 1) {
                    node = (Node)jcrSession.getItem(path);
                    String nodeType = node.getPrimaryNodeType().getName();
                    if (templateService.getDocumentTemplates().contains(nodeType)) {
                        variables.put("document-type", nodeType);
                        this.triggerAction(userId, variables);
                    }
                } else {
                    this.triggerAction(userId, variables);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public abstract void triggerAction(String var1, Map var2) throws Exception;
}

