/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.actions;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.nodetype.PropertyDefinition;
import javax.jcr.observation.EventListener;
import javax.jcr.observation.ObservationManager;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.utils.ISO8601;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.SessionContainer;
import org.exoplatform.services.cms.JcrInputProperty;
import org.exoplatform.services.cms.actions.ActionConfig;
import org.exoplatform.services.cms.actions.ActionPlugin;
import org.exoplatform.services.cms.actions.ActionServiceContainer;
import org.exoplatform.services.cms.actions.ECMEventListener;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.scheduler.JobInfo;
import org.exoplatform.services.scheduler.JobSchedulerService;
import org.exoplatform.services.scheduler.PeriodInfo;
import org.quartz.JobDataMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseActionPlugin
implements ActionPlugin {
    static final String JOB_NAME_PREFIX = "activate_".intern();
    static final String PERIOD_JOB = "period".intern();
    static final String CRON_JOB = "cron".intern();
    static final String SCHEDULABLE_INFO_MIXIN = "exo:schedulableInfo".intern();
    static final String SCHEDULED_INITIATOR = "exo:scheduledInitiator".intern();
    static final String JOB_NAME_PROP = "exo:jobName".intern();
    static final String JOB_GROUP_PROP = "exo:jobGroup".intern();
    static final String JOB_DESCRIPTION_PROP = "exo:jobDescription".intern();
    static final String JOB_CLASS_PROP = "exo:jobClass".intern();
    static final String SCHEDULE_TYPE_PROP = "exo:scheduleType".intern();
    static final String START_TIME_PROP = "exo:startTime".intern();
    static final String END_TIME_PROP = "exo:endTime".intern();
    static final String REPEAT_COUNT_PROP = "exo:repeatCount".intern();
    static final String TIME_INTERVAL_PROP = "exo:timeInterval".intern();
    static final String CRON_EXPRESSION_PROP = "exo:cronExpression".intern();
    static final String LIFECYCLE_PHASE_PROP = "exo:lifecyclePhase".intern();
    static final String NODE_NAME_PROP = "exo:name".intern();
    static final String COUNTER_PROP = "exo:counter".intern();
    static final long BUFFER_TIME = 500000L;
    static final String actionNameVar = "actionName".intern();
    static final String srcWorkspaceVar = "srcWorkspace".intern();
    static final String initiatorVar = "initiator".intern();
    static final String srcPathVar = "srcPath".intern();
    static final String executableVar = "executable".intern();
    private Map<String, Session> sessions = new HashMap<String, Session>();
    protected Map<String, ECMEventListener> listeners_ = new HashMap<String, ECMEventListener>();

    protected abstract String getWorkspace();

    protected abstract ManageableRepository getRepository() throws Exception;

    protected abstract String getActionType();

    protected abstract List getActions();

    protected abstract ECMEventListener createEventListener(String var1, String var2, String var3, String var4, Map var5) throws Exception;

    protected abstract Class createActivationJob() throws Exception;

    public void addAction(String actionType, String srcWorkspace, String srcPath, Map mappings) throws Exception {
        String actionName = (String)((JcrInputProperty)mappings.get("/node/exo:name")).getValue();
        mappings.remove("/node/exo:name");
        String type = (String)((JcrInputProperty)mappings.get("/node/exo:lifecyclePhase")).getValue();
        String actionExecutable = this.getActionExecutable(actionType);
        if ("read".equals(type)) {
            return;
        }
        if ("schedule".equals(type)) {
            this.scheduleActionActivationJob(srcWorkspace, srcPath, actionName, actionType, actionExecutable, mappings);
        } else {
            Map<String, Object> variables = this.getExecutionVariables(mappings);
            ECMEventListener listener = this.createEventListener(actionName, actionExecutable, srcWorkspace, srcPath, variables);
            ObservationManager obsManager = this.getSystemSession(srcWorkspace).getWorkspace().getObservationManager();
            if (this.listeners_.containsKey(srcPath + "/" + actionName)) {
                this.listeners_.remove(srcPath + "/" + actionName);
            } else if ("add".equals(type)) {
                obsManager.addEventListener((EventListener)listener, 1, srcPath, true, null, null, false);
            } else if ("remove".equals(type)) {
                obsManager.addEventListener((EventListener)listener, 2, srcPath, true, null, null, false);
            } else {
                obsManager.addEventListener((EventListener)listener, 16, srcPath, true, null, null, false);
            }
            this.listeners_.put(srcPath + "/" + actionName, listener);
        }
    }

    public void initiateActionObservation(Node storedActionNode) throws Exception {
        PropertyDefinition[] defs;
        String actionName = storedActionNode.getProperty("exo:name").getString();
        String lifecyclePhase = storedActionNode.getProperty("exo:lifecyclePhase").getString();
        String actionType = storedActionNode.getPrimaryNodeType().getName();
        String srcWorkspace = storedActionNode.getSession().getWorkspace().getName();
        String srcPath = storedActionNode.getParent().getPath();
        if ("read".equals(lifecyclePhase)) {
            return;
        }
        HashMap<String, Object> variables = new HashMap<String, Object>();
        NodeType nodeType = storedActionNode.getPrimaryNodeType();
        for (PropertyDefinition propDef : defs = nodeType.getPropertyDefinitions()) {
            if (propDef.isMultiple()) continue;
            String key = propDef.getName();
            try {
                Object value = this.getPropertyValue(storedActionNode.getProperty(key));
                variables.put(key, value);
            }
            catch (Exception e) {
                variables.put(key, null);
            }
        }
        String actionExecutable = this.getActionExecutable(actionType);
        ECMEventListener listener = this.createEventListener(actionName, actionExecutable, srcWorkspace, srcPath, variables);
        ObservationManager obsManager = this.getSystemSession(srcWorkspace).getWorkspace().getObservationManager();
        if (this.listeners_.containsKey(srcPath + "/" + actionName)) {
            this.listeners_.remove(srcPath + "/" + actionName);
        } else if ("add".equals(lifecyclePhase)) {
            obsManager.addEventListener((EventListener)listener, 1, srcPath, true, null, null, false);
        } else if ("remove".equals(lifecyclePhase)) {
            obsManager.addEventListener((EventListener)listener, 2, srcPath, true, null, null, false);
        } else {
            obsManager.addEventListener((EventListener)listener, 16, srcPath, true, null, null, false);
        }
        this.listeners_.put(srcPath + "/" + actionName, listener);
    }

    public void reScheduleActivations(Node storedActionNode) throws Exception {
        PropertyDefinition[] defs;
        String jobClassName = storedActionNode.getProperty(JOB_CLASS_PROP).getString();
        Class<?> activationJobClass = null;
        try {
            activationJobClass = Class.forName(jobClassName);
        }
        catch (Exception e) {
            return;
        }
        String actionName = storedActionNode.getProperty(NODE_NAME_PROP).getString();
        String actionType = storedActionNode.getPrimaryNodeType().getName();
        String srcWorkspace = storedActionNode.getSession().getWorkspace().getName();
        String scheduleType = storedActionNode.getProperty(SCHEDULE_TYPE_PROP).getString();
        String initiator = storedActionNode.getProperty(SCHEDULED_INITIATOR).getString();
        String srcPath = storedActionNode.getParent().getPath();
        String jobName = storedActionNode.getProperty(JOB_NAME_PROP).getString();
        String jobGroup = storedActionNode.getProperty(JOB_GROUP_PROP).getString();
        ExoContainer exoContainer = ExoContainerContext.getCurrentContainer();
        JobSchedulerService schedulerService = (JobSchedulerService)exoContainer.getComponentInstanceOfType(JobSchedulerService.class);
        HashMap<String, Object> variables = new HashMap<String, Object>();
        NodeType nodeType = storedActionNode.getPrimaryNodeType();
        for (PropertyDefinition propDef : defs = nodeType.getPropertyDefinitions()) {
            if (propDef.isMultiple()) continue;
            String key = propDef.getName();
            try {
                Object value = this.getPropertyValue(storedActionNode.getProperty(key));
                variables.put(key, value);
            }
            catch (Exception e) {
                variables.put(key, null);
            }
        }
        String actionExecutable = this.getActionExecutable(actionType);
        variables.put(initiatorVar, initiator);
        variables.put(actionNameVar, actionName);
        variables.put(executableVar, actionExecutable);
        variables.put(srcWorkspaceVar, srcWorkspace);
        variables.put(srcPathVar, srcPath);
        JobDataMap jdatamap = new JobDataMap();
        JobInfo jinfo = new JobInfo(jobName, jobGroup, activationJobClass);
        jdatamap.putAll(variables);
        if (CRON_JOB.equals(scheduleType)) {
            String cronExpression = storedActionNode.getProperty(CRON_EXPRESSION_PROP).getString();
            schedulerService.addCronJob(jinfo, cronExpression, jdatamap);
        } else {
            Calendar endTime = null;
            Date endDate = null;
            if (storedActionNode.hasProperty(END_TIME_PROP)) {
                endTime = storedActionNode.getProperty(END_TIME_PROP).getDate();
            }
            if (endTime != null) {
                endDate = endTime.getTime();
            }
            long timeInterval = storedActionNode.getProperty(TIME_INTERVAL_PROP).getLong();
            Date startDate = new Date(System.currentTimeMillis() + 500000L);
            int repeatCount = (int)storedActionNode.getProperty(REPEAT_COUNT_PROP).getLong();
            int counter = (int)storedActionNode.getProperty(COUNTER_PROP).getLong();
            PeriodInfo pinfo = new PeriodInfo(startDate, endDate, repeatCount - counter, timeInterval);
            schedulerService.addPeriodJob(jinfo, pinfo, jdatamap);
        }
    }

    protected Session getSystemSession(String workspace) throws Exception {
        Session session = this.sessions.get(workspace);
        if (session == null) {
            ManageableRepository jcrRepository = this.getRepository();
            session = jcrRepository.getSystemSession(workspace);
            this.sessions.put(workspace, session);
        }
        return session;
    }

    public String getActionExecutable(String actionTypeName) throws Exception {
        Session session = null;
        try {
            session = this.getSystemSession(this.getWorkspace());
        }
        catch (RepositoryException ex) {
            return null;
        }
        NodeTypeManager ntManager = session.getWorkspace().getNodeTypeManager();
        NodeType nt = ntManager.getNodeType(actionTypeName);
        PropertyDefinition[] propDefs = nt.getDeclaredPropertyDefinitions();
        for (int i = 0; i < propDefs.length; ++i) {
            PropertyDefinition definition = propDefs[i];
            if (!definition.getName().equals(this.getExecutableDefinitionName())) continue;
            return definition.getDefaultValues()[0].getString();
        }
        return null;
    }

    public boolean isActionTypeSupported(String actionType) {
        Session session = null;
        try {
            session = this.getSystemSession(this.getWorkspace());
            NodeTypeManager ntmanager = session.getWorkspace().getNodeTypeManager();
            NodeType[] superTypes = ntmanager.getNodeType(actionType).getSupertypes();
            for (int i = 0; i < superTypes.length; ++i) {
                NodeType type = superTypes[i];
                if (!this.getActionType().equals(type.getName())) continue;
                return true;
            }
            return false;
        }
        catch (Exception re) {
            return false;
        }
    }

    public void removeObservation(String actionName) throws Exception {
        ECMEventListener eventListener = this.listeners_.get(actionName);
        if (eventListener != null) {
            String srcWorkspace = eventListener.getSrcWorkspace();
            ObservationManager obsManager = this.getSystemSession(srcWorkspace).getWorkspace().getObservationManager();
            obsManager.removeEventListener((EventListener)eventListener);
        }
        this.listeners_.remove(actionName);
    }

    public void removeActivationJob(String jobName, String jobGroup, String jobClass) throws Exception {
        ExoContainer exoContainer = ExoContainerContext.getCurrentContainer();
        JobSchedulerService schedulerService = (JobSchedulerService)exoContainer.getComponentInstanceOfType(JobSchedulerService.class);
        Class<?> activationJob = null;
        try {
            activationJob = Class.forName(jobClass);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (activationJob == null) {
            return;
        }
        JobInfo jinfo = new JobInfo(jobName, jobGroup, activationJob);
        schedulerService.removeJob(jinfo);
    }

    public boolean isVariable(String variable) throws Exception {
        Session session = null;
        try {
            session = this.getSystemSession(this.getWorkspace());
        }
        catch (RepositoryException ex) {
            return false;
        }
        NodeTypeManager ntManager = session.getWorkspace().getNodeTypeManager();
        NodeType nt = ntManager.getNodeType(this.getActionType());
        PropertyDefinition[] propDefs = nt.getDeclaredPropertyDefinitions();
        for (int i = 0; i < propDefs.length; ++i) {
            PropertyDefinition definition = propDefs[i];
            if (!definition.getName().equals(variable)) continue;
            return false;
        }
        return true;
    }

    public Collection<String> getVariableNames(String actionTypeName) throws Exception {
        ArrayList<String> variableNames = new ArrayList<String>();
        Session session = null;
        try {
            session = this.getSystemSession(this.getWorkspace());
        }
        catch (RepositoryException ex) {
            // empty catch block
        }
        NodeTypeManager ntManager = session.getWorkspace().getNodeTypeManager();
        NodeType nt = ntManager.getNodeType(actionTypeName);
        PropertyDefinition[] propDefs = nt.getDeclaredPropertyDefinitions();
        for (int i = 0; i < propDefs.length; ++i) {
            PropertyDefinition definition = propDefs[i];
            if (!this.isVariable(definition.getName())) continue;
            variableNames.add(definition.getName());
        }
        return variableNames;
    }

    protected void importPredefinedActionsInJcr() throws Exception {
        Session session = null;
        List actions = this.getActions();
        if (actions.isEmpty()) {
            return;
        }
        for (ActionConfig.Action action : actions) {
            String actionName = action.getName();
            String nodeType = action.getType();
            String srcWorkspace = action.getSrcWorkspace();
            String srcPath = action.getSrcPath();
            session = this.getSystemSession(srcWorkspace);
            try {
                Node srcNode = (Node)session.getItem(srcPath);
                Node actionNode = null;
                boolean firstImport = false;
                if (!srcNode.hasNode(actionName)) {
                    firstImport = true;
                    if (!srcNode.isNodeType("exo:actionable")) {
                        srcNode.addMixin("exo:actionable");
                    }
                    actionNode = srcNode.addNode(actionName, nodeType);
                    actionNode.setProperty("exo:name", action.getName());
                    actionNode.setProperty("exo:description", action.getDescription());
                    if (action.getLifecyclePhase() != null) {
                        actionNode.setProperty("exo:lifecyclePhase", action.getLifecyclePhase());
                    }
                    if (action.getRoles() != null) {
                        String[] roles = StringUtils.split((String)action.getRoles(), (String)";");
                        actionNode.setProperty("exo:roles", roles);
                    }
                    for (ActionConfig.Mixin mixin : action.getMixins()) {
                        actionNode.addMixin(mixin.getName());
                        Map<String, String> props = mixin.getParsedProperties();
                        Set<String> keys = props.keySet();
                        for (String key : keys) {
                            actionNode.setProperty(key, props.get(key));
                        }
                    }
                } else {
                    actionNode = srcNode.getNode(actionName);
                }
                String unparsedVariables = action.getVariables();
                HashMap<String, String> variablesMap = new HashMap<String, String>();
                if (unparsedVariables != null && !"".equals(unparsedVariables)) {
                    String[] variables = StringUtils.split((String)unparsedVariables, (String)";");
                    for (int i = 0; i < variables.length; ++i) {
                        String variable = variables[i];
                        String[] keyValue = StringUtils.split((String)variable, (String)"=");
                        String variableKey = keyValue[0];
                        String variableValue = keyValue[1];
                        variablesMap.put(variableKey, variableValue);
                        if (!firstImport) continue;
                        actionNode.setProperty(variableKey, variableValue);
                    }
                }
                if (!firstImport) continue;
                srcNode.save();
            }
            catch (PathNotFoundException e) {}
        }
    }

    private void scheduleActionActivationJob(String srcWorkspace, String srcPath, String actionName, String actionType, String actionExecutable, Map mappings) throws Exception {
        Session session;
        Node srcNode;
        ExoContainer exoContainer = ExoContainerContext.getCurrentContainer();
        JobSchedulerService schedulerService = (JobSchedulerService)exoContainer.getComponentInstanceOfType(JobSchedulerService.class);
        ActionServiceContainer actionContainer = (ActionServiceContainer)exoContainer.getComponentInstanceOfType(ActionServiceContainer.class);
        Node actionNode = actionContainer.getAction(srcNode = (Node)(session = this.getSystemSession(srcWorkspace)).getItem(srcPath), actionName);
        if (!actionNode.isNodeType(SCHEDULABLE_INFO_MIXIN)) {
            actionNode.addMixin(SCHEDULABLE_INFO_MIXIN);
            actionNode.save();
        }
        Class activationJob = this.createActivationJob();
        String jobName = JOB_NAME_PREFIX.concat(actionName);
        String jobGroup = actionType;
        String userId = SessionContainer.getInstance().getRemoteUser();
        String scheduleType = null;
        String startTime = null;
        String endTime = null;
        String repeatCount = null;
        String timeInterval = null;
        String cronExpress = null;
        if (mappings.containsKey("/node/exo:scheduleType")) {
            scheduleType = (String)((JcrInputProperty)mappings.get("/node/exo:scheduleType")).getValue();
            mappings.remove("/node/exo:scheduleType");
        }
        if (mappings.containsKey("/node/exo:startTime")) {
            startTime = (String)((JcrInputProperty)mappings.get("/node/exo:startTime")).getValue();
            mappings.remove("/node/exo:startTime");
        }
        if (mappings.containsKey("/node/exo:endTime")) {
            endTime = (String)((JcrInputProperty)mappings.get("/node/exo:endTime")).getValue();
            mappings.remove("/node/exo:endTime");
        }
        if (mappings.containsKey("/node/exo:repeatCount")) {
            repeatCount = (String)((JcrInputProperty)mappings.get("/node/exo:repeatCount")).getValue();
            mappings.remove("/node/exo:repeatCount");
        }
        if (mappings.containsKey("/node/exo:timeInterval")) {
            timeInterval = (String)((JcrInputProperty)mappings.get("/node/exo:timeInterval")).getValue();
            mappings.remove("/node/exo:timeInterval");
        }
        if (mappings.containsKey("/node/exo:cronExpress")) {
            cronExpress = (String)((JcrInputProperty)mappings.get("/node/exo:cronExpress")).getValue();
            mappings.remove("/node/exo:cronExpress");
        }
        actionNode.setProperty(JOB_NAME_PROP, jobName);
        actionNode.setProperty(JOB_GROUP_PROP, jobGroup);
        actionNode.setProperty(JOB_CLASS_PROP, activationJob.getName());
        actionNode.setProperty(SCHEDULED_INITIATOR, userId);
        actionNode.setProperty(SCHEDULE_TYPE_PROP, scheduleType);
        actionNode.save();
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put(initiatorVar, userId);
        variables.put(actionNameVar, actionName);
        variables.put(executableVar, actionExecutable);
        variables.put(srcWorkspaceVar, srcWorkspace);
        variables.put(srcPathVar, srcPath);
        Map<String, Object> executionVariables = this.getExecutionVariables(mappings);
        JobDataMap jdatamap = new JobDataMap();
        jdatamap.putAll(variables);
        jdatamap.putAll(executionVariables);
        JobInfo jinfo = new JobInfo(jobName, jobGroup, activationJob);
        if (scheduleType.equals(CRON_JOB)) {
            actionNode.setProperty(CRON_EXPRESSION_PROP, cronExpress);
            actionNode.save();
            schedulerService.addCronJob(jinfo, cronExpress, jdatamap);
        } else {
            Date startDate = null;
            Date endDate = null;
            startDate = startTime != null && !startTime.equals("") ? ISO8601.parse((String)startTime).getTime() : new Date();
            if (endTime != null && !endTime.equals("")) {
                endDate = ISO8601.parse((String)endTime).getTime();
            }
            int repeatNum = Integer.parseInt(repeatCount);
            long period = Long.parseLong(timeInterval);
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(startDate);
            actionNode.setProperty(START_TIME_PROP, (Calendar)calendar);
            if (endDate != null) {
                calendar.setTime(endDate);
                actionNode.setProperty(END_TIME_PROP, (Calendar)calendar);
            }
            actionNode.setProperty(TIME_INTERVAL_PROP, period);
            actionNode.setProperty(REPEAT_COUNT_PROP, (long)repeatNum);
            actionNode.save();
            PeriodInfo pinfo = new PeriodInfo(startDate, endDate, repeatNum, period);
            schedulerService.addPeriodJob(jinfo, pinfo, jdatamap);
        }
        session.save();
    }

    private Map<String, Object> getExecutionVariables(Map mappings) {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        Set keys = mappings.keySet();
        for (String key : keys) {
            Object value = ((JcrInputProperty)mappings.get(key)).getValue();
            key = key.substring(key.lastIndexOf("/") + 1);
            variables.put(key, value);
        }
        return variables;
    }

    private Object getPropertyValue(Property property) throws Exception {
        int propertyType = property.getType();
        switch (propertyType) {
            case 1: {
                return property.getValue().getString();
            }
            case 6: {
                return property.getValue().getBoolean();
            }
            case 5: {
                return property.getValue().getDate();
            }
            case 4: {
                return property.getValue().getDouble();
            }
            case 3: {
                return property.getValue().getLong();
            }
            case 7: {
                return property.getValue().getString();
            }
            case 0: {
                return property.getValue();
            }
        }
        return null;
    }
}

