/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import org.drools.WorkingMemory;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.cms.actions.ActionConfig;
import org.exoplatform.services.cms.actions.BaseActionLauncherListener;
import org.exoplatform.services.cms.actions.BaseActionPlugin;
import org.exoplatform.services.cms.actions.ECMEventListener;
import org.exoplatform.services.cms.actions.activation.RuleActionActivationJob;
import org.exoplatform.services.cms.rules.RuleService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuleActionPlugin
extends BaseActionPlugin
implements ComponentPlugin {
    public static final String ACTION_TYPE = "exo:ruleAction";
    private RepositoryService repositoryService_;
    private ActionConfig config_;
    private RuleService ruleService_;

    public RuleActionPlugin(RuleService ruleService, InitParams params, RepositoryService repositoryService) throws Exception {
        this.ruleService_ = ruleService;
        this.repositoryService_ = repositoryService;
        this.config_ = (ActionConfig)params.getObjectParamValues(ActionConfig.class).get(0);
    }

    @Override
    protected String getWorkspace() {
        return this.config_.getWorkspace();
    }

    @Override
    protected ManageableRepository getRepository() throws Exception {
        return this.repositoryService_.getRepository();
    }

    @Override
    protected String getActionType() {
        return ACTION_TYPE;
    }

    @Override
    protected List getActions() {
        return this.config_.getActions();
    }

    public String getExecutableDefinitionName() {
        return "exo:rule";
    }

    @Override
    protected ECMEventListener createEventListener(String actionName, String actionExecutable, String srcWorkspace, String srcPath, Map variables) throws Exception {
        return new RuleActionLauncherListener(actionName, actionExecutable, srcWorkspace, srcPath, variables);
    }

    public Collection<String> getActionExecutables() throws Exception {
        ArrayList<String> ruleNames = new ArrayList<String>();
        NodeIterator iter = this.ruleService_.getRules();
        while (iter.hasNext()) {
            Node node = iter.nextNode();
            ruleNames.add(node.getName());
        }
        return ruleNames;
    }

    public String getActionExecutableLabel() {
        return "Defined Rules: ";
    }

    public String getName() {
        return ACTION_TYPE;
    }

    public void setName(String s) {
    }

    public String getDescription() {
        return "Add a action service";
    }

    public void setDescription(String desc) {
    }

    public void executeAction(String userId, Node actionNode, Map variables) throws Exception {
        String rule = actionNode.getProperty("exo:rule").getString();
        this.executeAction(userId, rule, variables);
    }

    public void executeAction(String userId, String executable, Map variables) throws Exception {
        ExoContainer exoContainer = ExoContainerContext.getCurrentContainer();
        RuleService ruleService = (RuleService)exoContainer.getComponentInstanceOfType(RuleService.class);
        WorkingMemory workingMemory = ruleService.getRule(executable);
        workingMemory.assertObject((Object)variables);
        workingMemory.fireAllRules();
    }

    public void activateAction(String userId, String executable, Map variables) throws Exception {
        this.executeAction(userId, executable, variables);
    }

    @Override
    protected Class createActivationJob() throws Exception {
        return RuleActionActivationJob.class;
    }

    public class RuleActionLauncherListener
    extends BaseActionLauncherListener {
        public RuleActionLauncherListener(String actionName, String rule, String srcWorkspace, String srcPath, Map actionVariables) throws Exception {
            super(actionName, rule, srcWorkspace, srcPath, actionVariables);
        }

        public void triggerAction(String userId, Map variables) throws Exception {
            RuleActionPlugin.this.executeAction(userId, this.executable_, variables);
        }
    }
}

