/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.cms.actions.ActionConfig;
import org.exoplatform.services.cms.actions.BaseActionLauncherListener;
import org.exoplatform.services.cms.actions.BaseActionPlugin;
import org.exoplatform.services.cms.actions.ECMEventListener;
import org.exoplatform.services.cms.actions.activation.ScriptActionActivationJob;
import org.exoplatform.services.cms.scripts.CmsScript;
import org.exoplatform.services.cms.scripts.ScriptService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptActionPlugin
extends BaseActionPlugin
implements ComponentPlugin {
    public static final String ACTION_TYPE = "exo:scriptAction";
    private ScriptService scriptService_;
    private RepositoryService repositoryService_;
    private ActionConfig config_;

    public ScriptActionPlugin(ScriptService scriptService, InitParams params, RepositoryService repositoryService) throws Exception {
        this.scriptService_ = scriptService;
        this.repositoryService_ = repositoryService;
        this.config_ = (ActionConfig)params.getObjectParamValues(ActionConfig.class).get(0);
    }

    public Collection<String> getActionExecutables() throws Exception {
        ArrayList<String> actionScriptNames = new ArrayList<String>();
        List actionScriptList = this.scriptService_.getECMActionScripts();
        String baseScriptPath = this.scriptService_.getBaseScriptPath();
        for (Node script : actionScriptList) {
            String actionScriptName = StringUtils.substringAfter((String)script.getPath(), (String)(baseScriptPath + "/"));
            actionScriptNames.add(actionScriptName);
        }
        return actionScriptNames;
    }

    public String getActionExecutableLabel() {
        return "Groovy Scripts:";
    }

    public String getExecutableDefinitionName() {
        return "exo:script";
    }

    @Override
    protected String getWorkspace() {
        return this.config_.getWorkspace();
    }

    @Override
    protected ManageableRepository getRepository() throws Exception {
        return this.repositoryService_.getRepository();
    }

    @Override
    protected String getActionType() {
        return ACTION_TYPE;
    }

    @Override
    protected List getActions() {
        return this.config_.getActions();
    }

    @Override
    protected ECMEventListener createEventListener(String actionName, String actionExecutable, String srcWorkspace, String srcPath, Map variables) throws Exception {
        return new ScriptActionLauncherListener(actionName, actionExecutable, srcWorkspace, srcPath, variables);
    }

    public String getName() {
        return ACTION_TYPE;
    }

    public void setName(String s) {
    }

    public String getDescription() {
        return "Add a action service";
    }

    public void setDescription(String desc) {
    }

    public void executeAction(String userId, Node actionNode, Map variables) throws Exception {
        String script = actionNode.getProperty("exo:script").getString();
        variables.put("actionNode", actionNode);
        this.executeAction(userId, script, variables);
    }

    public void executeAction(String userId, String executable, Map variables) throws Exception {
        ExoContainer exoContainer = ExoContainerContext.getCurrentContainer();
        ScriptService scriptService = (ScriptService)exoContainer.getComponentInstanceOfType(ScriptService.class);
        CmsScript cmsScript = scriptService.getScript(executable);
        cmsScript.execute((Object)variables);
    }

    public void activateAction(String userId, String executable, Map variables) throws Exception {
        this.executeAction(userId, executable, variables);
    }

    @Override
    protected Class createActivationJob() throws Exception {
        return ScriptActionActivationJob.class;
    }

    public class ScriptActionLauncherListener
    extends BaseActionLauncherListener {
        public ScriptActionLauncherListener(String actionName, String script, String srcWorkspace, String srcPath, Map actionVariables) throws Exception {
            super(actionName, script, srcWorkspace, srcPath, actionVariables);
        }

        public void triggerAction(String userId, Map variables) throws Exception {
            ScriptActionPlugin.this.executeAction(userId, this.executable_, variables);
        }
    }
}

