/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.actions.activation;

import java.util.Map;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.Session;
import javax.jcr.Value;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.cms.actions.ActionPlugin;
import org.exoplatform.services.cms.actions.ActionServiceContainer;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.security.SecurityService;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class ScriptActionActivationJob
implements Job {
    private static final String COUNTER_PROP = "exo:counter".intern();

    public void execute(JobExecutionContext context) throws JobExecutionException {
        ExoContainer exoContainer = ExoContainerContext.getCurrentContainer();
        RepositoryService repositoryService = (RepositoryService)exoContainer.getComponentInstanceOfType(RepositoryService.class);
        ActionServiceContainer actionServiceContainer = (ActionServiceContainer)exoContainer.getComponentInstanceOfType(ActionServiceContainer.class);
        SecurityService securityService = (SecurityService)exoContainer.getComponentInstanceOfType(SecurityService.class);
        ActionPlugin scriptActionService = actionServiceContainer.getActionPlugin("exo:scriptAction");
        Session jcrSession = null;
        Node actionNode = null;
        JobDataMap jdatamap = context.getJobDetail().getJobDataMap();
        String userId = jdatamap.getString("initiator");
        String srcWorkspace_ = jdatamap.getString("srcWorkspace");
        String srcPath_ = jdatamap.getString("srcPath");
        String actionName_ = jdatamap.getString("actionName");
        String executable = jdatamap.getString("executable");
        Map variables = jdatamap.getWrappedMap();
        try {
            jcrSession = repositoryService.getRepository().getSystemSession(srcWorkspace_);
            Node node = (Node)jcrSession.getItem(srcPath_);
            actionNode = actionServiceContainer.getInitAction(node, actionName_);
            Property rolesProp = actionNode.getProperty("exo:roles");
            boolean hasPermission = false;
            Value[] roles = rolesProp.getValues();
            for (int i = 0; i < roles.length; ++i) {
                String role = roles[i].getString();
                if (!securityService.hasMembershipInGroup(userId, role) && !"__system".equals(userId)) continue;
                hasPermission = true;
                break;
            }
            if (!hasPermission) {
                return;
            }
            scriptActionService.activateAction(userId, executable, variables);
            int currentCounter = (int)actionNode.getProperty(COUNTER_PROP).getValue().getLong();
            actionNode.setProperty(COUNTER_PROP, (long)(currentCounter + 1));
            actionNode.save();
            jcrSession.save();
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }
}

