/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.comments.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import org.exoplatform.container.SessionContainer;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.cms.comments.CommentsService;
import org.exoplatform.services.cms.i18n.MultiLanguageService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommentsServiceImpl
implements CommentsService {
    private static final String COMMENTS = "comments".intern();
    private static final String COMMENTABLE = "mix:commentable".intern();
    private static final String EXO_COMMENTS = "exo:comments".intern();
    private static final String NT_UNSTRUCTURE = "nt:unstructured".intern();
    private static final String MIX_I18N = "mix:i18n".intern();
    private static final String MESSAGE = "exo:commentContent".intern();
    private static final String COMMENTOR = "exo:commentor".intern();
    private static final String COMMENTOR_EMAIL = "exo:commentorEmail".intern();
    private static final String COMMENTOR_SITE = "exo:commentorSite".intern();
    private static final String CREATED_DATE = "exo:commentDate".intern();
    private static final String LANGUAGES = "languages".intern();
    private static final String ANONYMOUS = "anonymous".intern();
    private ExoCache commentsCache_;
    private MultiLanguageService multiLangService_;

    public CommentsServiceImpl(CacheService cacheService, MultiLanguageService multiLangService) throws Exception {
        this.commentsCache_ = cacheService.getCacheInstance(CommentsService.class.getName());
        this.multiLangService_ = multiLangService;
    }

    public void addComment(Node document, String commentor, String email, String site, String comment, String language) throws Exception {
        if (!document.isNodeType(COMMENTABLE)) {
            if (document.canAddMixin(COMMENTABLE)) {
                document.addMixin(COMMENTABLE);
            } else {
                throw new Exception("This node does not support comments.");
            }
        }
        Node multiLanguages = null;
        Node languageNode = null;
        Node commentNode = null;
        commentNode = document.isNodeType(MIX_I18N) ? ((languageNode = (multiLanguages = !document.hasNode(LANGUAGES) ? document.addNode(LANGUAGES, NT_UNSTRUCTURE) : document.getNode(LANGUAGES)).hasNode(language) ? multiLanguages.getNode(language) : multiLanguages.addNode(language)).hasNode(COMMENTS) ? languageNode.getNode(COMMENTS) : languageNode.addNode(COMMENTS, NT_UNSTRUCTURE)) : (document.hasNode(COMMENTS) ? document.getNode(COMMENTS) : document.addNode(COMMENTS, NT_UNSTRUCTURE));
        if (commentor == null || commentor.length() == 0) {
            String userID = SessionContainer.getInstance().getRemoteUser();
            commentor = userID == null || userID.length() == 0 ? ANONYMOUS : userID;
        }
        GregorianCalendar commentDate = new GregorianCalendar();
        String name = Long.toString(commentDate.getTimeInMillis());
        Node newComment = commentNode.addNode(name, EXO_COMMENTS);
        newComment.setProperty(COMMENTOR, commentor);
        newComment.setProperty(CREATED_DATE, (Calendar)commentDate);
        newComment.setProperty(MESSAGE, comment);
        if (email != null && email.length() > 0) {
            newComment.setProperty(COMMENTOR_EMAIL, email);
        }
        if (site != null && site.length() > 0) {
            newComment.setProperty(COMMENTOR_SITE, site);
        }
        document.save();
        document.getSession().save();
        this.commentsCache_.remove((Serializable)((Object)commentNode.getPath()));
    }

    public List<Node> getComments(Node document, String language) throws Exception {
        String commentsNodeName = null;
        Node commentsNode = null;
        if (document.isNodeType(MIX_I18N)) {
            if (!this.isSupportedLocalize(document, language)) {
                language = document.getProperty("exo:language").getString();
            }
            commentsNodeName = LANGUAGES + "/" + language + "/" + COMMENTS;
        } else {
            commentsNodeName = COMMENTS;
        }
        if (!document.hasNode(commentsNodeName)) {
            return new ArrayList<Node>();
        }
        commentsNode = document.getNode(commentsNodeName);
        String cacheKey = document.getPath().concat(commentsNode.getPath());
        Object comments = this.commentsCache_.get((Serializable)((Object)cacheKey));
        if (comments != null) {
            return (List)comments;
        }
        ArrayList<Node> list = new ArrayList<Node>();
        NodeIterator iter = commentsNode.getNodes();
        while (iter.hasNext()) {
            list.add(iter.nextNode());
        }
        Collections.sort(list, new DateComparator());
        this.commentsCache_.put((Serializable)((Object)commentsNode.getPath()), list);
        return list;
    }

    private boolean isSupportedLocalize(Node document, String language) throws Exception {
        List locales = this.multiLangService_.getSupportedLanguages(document);
        return Collections.frequency(locales, language) > 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DateComparator
    implements Comparator<Node> {
        private DateComparator() {
        }

        @Override
        public int compare(Node node1, Node node2) {
            try {
                Date date1 = node1.getProperty(CREATED_DATE).getDate().getTime();
                Date date2 = node2.getProperty(CREATED_DATE).getDate().getTime();
                return date2.compareTo(date1);
            }
            catch (Exception exception) {
                return 0;
            }
        }
    }
}

