/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.drives;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import org.exoplatform.services.cms.CmsConfigurationService;
import org.exoplatform.services.cms.drives.DriveData;
import org.exoplatform.services.cms.drives.ManageDrivePlugin;
import org.exoplatform.services.cms.drives.ManageDriveService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;

public class ManageDriveServiceImpl
implements ManageDriveService {
    private static String WORKSPACE = "exo:workspace".intern();
    private static String PERMISSIONS = "exo:permissions".intern();
    private static String VIEWS = "exo:views".intern();
    private static String ICON = "exo:icon".intern();
    private static String PATH = "exo:path".intern();
    private static String VIEW_REFERENCES = "exo:viewPreferences".intern();
    private static String VIEW_NON_DOCUMENT = "exo:viewNonDocument".intern();
    private static String VIEW_EXPLORER = "exo:viewExplorer".intern();
    private static String VIEW_CLIPBOARD = "exo:viewClipboard".intern();
    private ManageDrivePlugin drivePlugin_;
    private RepositoryService jcrService_;
    private CmsConfigurationService cmsConfigurationService_;
    private Session session_;

    public ManageDriveServiceImpl(RepositoryService jcrService, CmsConfigurationService cmsConfigurationService) throws Exception {
        this.jcrService_ = jcrService;
        this.cmsConfigurationService_ = cmsConfigurationService;
        ManageableRepository jcrRepository = this.jcrService_.getRepository();
        this.session_ = jcrRepository.getSystemSession(this.cmsConfigurationService_.getWorkspace());
    }

    public void setManageDrivePlugin(ManageDrivePlugin drivePlugin) {
        this.drivePlugin_ = drivePlugin;
    }

    public Node getDriveHome() throws Exception {
        String drivesPath = this.cmsConfigurationService_.getJcrPath("exoDrivesPath");
        this.session_.refresh(false);
        return (Node)this.session_.getItem(drivesPath);
    }

    public List getAllDrives() throws Exception {
        Node driveHome = this.getDriveHome();
        NodeIterator itr = driveHome.getNodes();
        ArrayList<DriveData> driveList = new ArrayList<DriveData>();
        while (itr.hasNext()) {
            DriveData data = new DriveData();
            Node drive = itr.nextNode();
            data.setName(drive.getName());
            data.setWorkspace(drive.getProperty(WORKSPACE).getString());
            data.setHomePath(drive.getProperty(PATH).getString());
            data.setPermissions(drive.getProperty(PERMISSIONS).getString());
            data.setViews(drive.getProperty(VIEWS).getString());
            data.setIcon(drive.getProperty(ICON).getString());
            data.setViewPreferences(Boolean.parseBoolean(drive.getProperty(VIEW_REFERENCES).getString()));
            data.setViewNonDocument(Boolean.parseBoolean(drive.getProperty(VIEW_NON_DOCUMENT).getString()));
            data.setViewExplorer(Boolean.parseBoolean(drive.getProperty(VIEW_EXPLORER).getString()));
            data.setViewClipboard(Boolean.parseBoolean(drive.getProperty(VIEW_CLIPBOARD).getString()));
            driveList.add(data);
        }
        return driveList;
    }

    public DriveData getDriveByName(String name) throws Exception {
        Node driveHome = this.getDriveHome();
        if (driveHome.hasNode(name)) {
            Node drive = driveHome.getNode(name);
            DriveData data = new DriveData();
            data.setName(drive.getName());
            data.setWorkspace(drive.getProperty(WORKSPACE).getString());
            data.setHomePath(drive.getProperty(PATH).getString());
            data.setPermissions(drive.getProperty(PERMISSIONS).getString());
            data.setViews(drive.getProperty(VIEWS).getString());
            data.setIcon(drive.getProperty(ICON).getString());
            data.setViewPreferences(Boolean.parseBoolean(drive.getProperty(VIEW_REFERENCES).getString()));
            data.setViewNonDocument(Boolean.parseBoolean(drive.getProperty(VIEW_NON_DOCUMENT).getString()));
            data.setViewExplorer(Boolean.parseBoolean(drive.getProperty(VIEW_EXPLORER).getString()));
            data.setViewClipboard(Boolean.parseBoolean(drive.getProperty(VIEW_CLIPBOARD).getString()));
            return data;
        }
        return null;
    }

    public void addDrive(String name, String workspace, String permissions, String homePath, String views, String icon, boolean viewReferences, boolean viewNonDocument, boolean viewExplorer, boolean viewClipboard) throws Exception {
        this.drivePlugin_.addDrive(name, workspace, permissions, homePath, views, icon, viewReferences, viewNonDocument, viewExplorer, viewClipboard);
    }

    public List getAllDriveByPermission(String permission) throws Exception {
        ArrayList<DriveData> driveByPermission = new ArrayList<DriveData>();
        try {
            List driveList = this.getAllDrives();
            for (int i = 0; i < driveList.size(); ++i) {
                DriveData drive = (DriveData)driveList.get(i);
                if (!drive.hasPermission(permission)) continue;
                driveByPermission.add(drive);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return driveByPermission;
    }

    public void removeDrive(String driveName) throws Exception {
        Node driveHome = this.getDriveHome();
        if (driveHome.hasNode(driveName)) {
            driveHome.getNode(driveName).remove();
            driveHome.save();
        }
    }
}

