/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.folksonomy.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.Session;
import javax.jcr.Value;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.cms.CmsConfigurationService;
import org.exoplatform.services.cms.folksonomy.FolksonomyService;
import org.exoplatform.services.cms.folksonomy.impl.TagStyleConfig;
import org.exoplatform.services.cms.folksonomy.impl.TagStylePlugin;
import org.exoplatform.services.cms.impl.Utils;
import org.exoplatform.services.jcr.RepositoryService;
import org.picocontainer.Startable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FolksonomyServiceImpl
implements FolksonomyService,
Startable {
    private static final String EXO_FOLKSONOMIZED_MIXIN = "exo:folksonomized".intern();
    private static final String EXO_FOLKSONOMY_PROP = "exo:folksonomy".intern();
    private static final String MIX_REFERENCEABLE_MIXIN = "mix:referenceable".intern();
    private static final String EXO_TAG = "exo:tag".intern();
    private static final String TAG_CREATED_DATE_PROP = "exo:tagCreatedDate".intern();
    private static final String TAG_STATUS_PROP = "exo:tagStatus".intern();
    private static final String TAG_LAST_UPDATED_DATE_PROP = "exo:lastUpdatedDate".intern();
    private static final String EXO_TAG_STYLE = "exo:tagStyle".intern();
    private static final String TAG_RATE_PROP = "exo:styleRange".intern();
    private static final String HTML_STYLE_PROP = "exo:htmlStyle".intern();
    private static final String NORMAL_STYLE = "nomal".intern();
    private static final String INTERSTING_STYLE = "interesting".intern();
    private static final String ATTRACTIVE_STYLE = "attractive".intern();
    private static final String HOT_STYLE = "hot".intern();
    private static final String HOSTES_STYLE = "hotest".intern();
    private RepositoryService repoService_;
    private CmsConfigurationService cmsConfigService_;
    private String exoTagsPath_;
    private String exoTagStylePath_;
    private List<TagStylePlugin> plugin_ = new ArrayList<TagStylePlugin>();
    private ExoCache cache_;
    private Session systemSession_ = null;

    public FolksonomyServiceImpl(RepositoryService repoService, CmsConfigurationService cmsConfigService, CacheService cacheService) throws Exception {
        this.repoService_ = repoService;
        this.cmsConfigService_ = cmsConfigService;
        this.exoTagsPath_ = this.cmsConfigService_.getJcrPath("exoTagsPath");
        this.exoTagStylePath_ = this.cmsConfigService_.getJcrPath("exoTagStylePath");
        this.cache_ = cacheService.getCacheInstance(FolksonomyServiceImpl.class.getName());
    }

    public void addTagStylePlugin(ComponentPlugin plugin) {
        if (plugin instanceof TagStylePlugin) {
            this.plugin_.add((TagStylePlugin)plugin);
        }
    }

    public void addTag(Node node, String[] tagNames) throws Exception {
        Session systemSession = this.getSystemSession();
        Session currentSession = node.getSession();
        Node exoTagsHomeNode_ = (Node)systemSession.getItem(this.exoTagsPath_);
        Node taggingNode = null;
        for (String tagName : tagNames) {
            if (!exoTagsHomeNode_.hasNode(tagName)) {
                taggingNode = exoTagsHomeNode_.addNode(tagName, EXO_TAG);
                taggingNode.addMixin(MIX_REFERENCEABLE_MIXIN);
                taggingNode.setProperty(TAG_CREATED_DATE_PROP, (Calendar)new GregorianCalendar());
                taggingNode.setProperty(TAG_STATUS_PROP, "nomal");
            } else {
                taggingNode = exoTagsHomeNode_.getNode(tagName);
            }
            Value value2add = currentSession.getValueFactory().createValue(taggingNode);
            if (!node.isNodeType(EXO_FOLKSONOMIZED_MIXIN)) {
                node.addMixin(EXO_FOLKSONOMIZED_MIXIN);
                node.setProperty(EXO_FOLKSONOMY_PROP, new Value[]{value2add});
            } else {
                Value[] folksonomyValues = node.getProperty(EXO_FOLKSONOMY_PROP).getValues();
                String currenUUID = taggingNode.getUUID();
                ArrayList<Value> vals = new ArrayList<Value>();
                for (Value value : folksonomyValues) {
                    String uuid = value.getString();
                    if (uuid.equals(currenUUID)) {
                        return;
                    }
                    vals.add(value);
                }
                vals.add(value2add);
                node.setProperty(EXO_FOLKSONOMY_PROP, vals.toArray(new Value[vals.size()]));
            }
            exoTagsHomeNode_.save();
            node.save();
            this.cache_.remove((Serializable)((Object)taggingNode.getPath()));
            this.cache_.remove((Serializable)((Object)this.exoTagsPath_));
            this.cache_.remove((Serializable)((Object)node.getPath()));
            this.updateTagStatus(taggingNode.getPath());
        }
        currentSession.save();
        systemSession.save();
    }

    public Node getTag(String path) throws Exception {
        Session systemSession = this.getSystemSession();
        return (Node)systemSession.getItem(path);
    }

    public List<Node> getDocumentsOnTag(String tagPath) throws Exception {
        String[] workspaces;
        if (this.cache_.get((Serializable)((Object)tagPath)) != null) {
            return (List)this.cache_.get((Serializable)((Object)tagPath));
        }
        ArrayList<Node> documentList = new ArrayList<Node>();
        Session systemSession = this.getSystemSession();
        Node tagNode = (Node)systemSession.getItem(tagPath);
        String uuid = tagNode.getUUID();
        for (String workspaceName : workspaces = this.repoService_.getRepository().getWorkspaceNames()) {
            Session sessionOnWS = this.getSystemSession(workspaceName);
            Node tagNodeOnWS = sessionOnWS.getNodeByUUID(uuid);
            PropertyIterator iter = tagNodeOnWS.getReferences();
            while (iter.hasNext()) {
                Property folksonomy = iter.nextProperty();
                Node document = folksonomy.getParent();
                documentList.add(document);
            }
        }
        this.cache_.put((Serializable)((Object)tagPath), documentList);
        return documentList;
    }

    public List<Node> getAllTags() throws Exception {
        Object cachedList = this.cache_.get((Serializable)((Object)this.exoTagsPath_));
        if (cachedList != null) {
            return (List)cachedList;
        }
        ArrayList<Node> tagList = new ArrayList<Node>();
        Session systemSession = this.getSystemSession();
        Node exoTagsHomeNode_ = (Node)systemSession.getItem(this.exoTagsPath_);
        NodeIterator iter = exoTagsHomeNode_.getNodes();
        while (iter.hasNext()) {
            tagList.add(iter.nextNode());
        }
        this.cache_.put((Serializable)((Object)this.exoTagsPath_), tagList);
        return tagList;
    }

    public List<Node> getAllTagStyle() throws Exception {
        Object cachedList = this.cache_.get((Serializable)((Object)this.exoTagStylePath_));
        if (cachedList != null) {
            return (List)cachedList;
        }
        ArrayList<Node> tagStyleList = new ArrayList<Node>();
        Session systemSession = this.getSystemSession();
        Node tagStyleHomeNode = (Node)systemSession.getItem(this.exoTagStylePath_);
        NodeIterator iter = tagStyleHomeNode.getNodes();
        while (iter.hasNext()) {
            tagStyleList.add(iter.nextNode());
        }
        this.cache_.put((Serializable)((Object)this.exoTagStylePath_), tagStyleList);
        return tagStyleList;
    }

    protected Session getSystemSession() throws Exception {
        if (this.systemSession_ != null) {
            return this.systemSession_;
        }
        return this.getSystemSession(this.cmsConfigService_.getWorkspace());
    }

    protected Session getSystemSession(String workspace) throws Exception {
        Session session = this.repoService_.getRepository().getSystemSession(workspace);
        return session;
    }

    public String getTagStyle(String styleName) throws Exception {
        Object cachedObj = this.cache_.get((Serializable)((Object)styleName));
        if (cachedObj != null) {
            return (String)cachedObj;
        }
        Session systemSession = this.getSystemSession();
        Node tagStyleHomeNode = (Node)systemSession.getItem(this.exoTagStylePath_);
        Node tagStyle = tagStyleHomeNode.getNode(styleName);
        String htmlStyle = tagStyle.getProperty(HTML_STYLE_PROP).getValue().getString();
        this.cache_.put((Serializable)((Object)styleName), (Object)htmlStyle);
        return htmlStyle;
    }

    public void updateStype(String tagPath, String tagRate, String htmlStyle) throws Exception {
        Session session = this.getSystemSession();
        Node tagStyle = (Node)session.getItem(tagPath);
        tagStyle.setProperty(TAG_RATE_PROP, tagRate);
        tagStyle.setProperty(HTML_STYLE_PROP, htmlStyle);
        tagStyle.save();
        session.save();
        this.cache_.remove((Serializable)((Object)tagStyle.getName()));
        this.cache_.remove((Serializable)((Object)this.exoTagsPath_));
        this.cache_.remove((Serializable)((Object)this.exoTagStylePath_));
    }

    private void updateTagStatus(String tagPath) throws Exception {
        int numberOfDocumentOnTag = this.getDocumentsOnTag(tagPath).size();
        Session systemSession = this.getSystemSession();
        Node selectedTagNode = (Node)systemSession.getItem(tagPath);
        Node tagStyleHomeNode = (Node)systemSession.getItem(this.exoTagStylePath_);
        Node tagStyle = null;
        NodeIterator iter = tagStyleHomeNode.getNodes();
        while (iter.hasNext()) {
            Node node = iter.nextNode();
            if (!this.checkTagRateOnTagStyle(numberOfDocumentOnTag, node)) continue;
            tagStyle = node;
            break;
        }
        if (tagStyle != null) {
            String styleName = tagStyle.getName();
            if (NORMAL_STYLE.equals(styleName)) {
                selectedTagNode.setProperty(TAG_STATUS_PROP, "nomal");
            } else if (INTERSTING_STYLE.equals(styleName)) {
                selectedTagNode.setProperty(TAG_STATUS_PROP, "interesting");
            } else if (ATTRACTIVE_STYLE.equals(styleName)) {
                selectedTagNode.setProperty(TAG_STATUS_PROP, "attractive");
            } else if (HOT_STYLE.equals(styleName)) {
                selectedTagNode.setProperty(TAG_STATUS_PROP, "hot");
            } else if (HOSTES_STYLE.equals(styleName)) {
                selectedTagNode.setProperty(TAG_STATUS_PROP, "hotest");
            }
            selectedTagNode.setProperty(TAG_LAST_UPDATED_DATE_PROP, (Calendar)new GregorianCalendar());
            selectedTagNode.save();
            systemSession.save();
            systemSession.refresh(true);
        }
    }

    private boolean checkTagRateOnTagStyle(int numOfDocument, Node tagStyle) throws Exception {
        String tagRate = tagStyle.getProperty(TAG_RATE_PROP).getValue().getString();
        String[] vals = StringUtils.split((String)tagRate, (String)"..");
        int minValue = Integer.parseInt(vals[0]);
        int maxValue = vals[1].equals("*") ? Integer.MAX_VALUE : Integer.parseInt(vals[1]);
        return minValue <= numOfDocument && numOfDocument < maxValue;
    }

    private void init() throws Exception {
        Session session = this.repoService_.getRepository().getSystemSession(this.cmsConfigService_.getWorkspace());
        Node exoTagStyleHomeNode = (Node)session.getItem(this.exoTagStylePath_);
        for (TagStylePlugin plugin : this.plugin_) {
            List<TagStyleConfig.HtmlTagStyle> htmlStyle4Tag = plugin.getTagStyleList();
            for (TagStyleConfig.HtmlTagStyle style : htmlStyle4Tag) {
                Node tagStyleNode = Utils.makePath(exoTagStyleHomeNode, "/" + style.getName(), EXO_TAG_STYLE);
                tagStyleNode.setProperty(TAG_RATE_PROP, style.getTagRate());
                tagStyleNode.setProperty(HTML_STYLE_PROP, style.getHtmlStyle());
            }
        }
        exoTagStyleHomeNode.save();
        session.save();
    }

    public void start() {
        try {
            this.init();
        }
        catch (Exception e) {
            System.out.println("===>>>>Exception when init FolksonomySerice" + e.getMessage());
        }
    }

    public void stop() {
    }

    public List<Node> getLinkedTagsOfDocument(Node document) throws Exception {
        if (document == null || !document.hasProperty(EXO_FOLKSONOMY_PROP)) {
            return new ArrayList<Node>();
        }
        if (this.cache_.get((Serializable)((Object)document.getPath())) != null) {
            return (List)this.cache_.get((Serializable)((Object)document.getPath()));
        }
        ArrayList<Node> tagList = new ArrayList<Node>();
        Session systemSession = this.getSystemSession();
        try {
            Value[] values;
            for (Value v : values = document.getProperty(EXO_FOLKSONOMY_PROP).getValues()) {
                String uuid = v.getString();
                tagList.add(systemSession.getNodeByUUID(uuid));
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        this.cache_.put((Serializable)((Object)document.getPath()), tagList);
        return tagList;
    }
}

