/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.i18n;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Value;
import javax.jcr.Workspace;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.PropertyDefinition;
import org.exoplatform.services.cms.i18n.MultiLanguageService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiLanguageServiceImpl
implements MultiLanguageService {
    public static final String JCRCONTENT = "jcr:content";
    public static final String JCRDATA = "jcr:data";
    public static final String NTUNSTRUCTURED = "nt:unstructured";

    public void addLanguage(Node node, Map inputs, String language, boolean isDefault) throws Exception {
        NodeType[] mixins;
        PropertyDefinition[] properties;
        Node newLanguageNode = null;
        Node languagesNode = null;
        String defaultLanguage = this.getDefault(node);
        languagesNode = node.hasNode("languages") ? node.getNode("languages") : node.addNode("languages", NTUNSTRUCTURED);
        if (!defaultLanguage.equals(language)) {
            newLanguageNode = isDefault ? (languagesNode.hasNode(defaultLanguage) ? languagesNode.getNode(defaultLanguage) : languagesNode.addNode(defaultLanguage)) : (languagesNode.hasNode(language) ? languagesNode.getNode(language) : languagesNode.addNode(language));
        }
        for (PropertyDefinition pro : properties = node.getPrimaryNodeType().getPropertyDefinitions()) {
            if (pro.isProtected()) continue;
            String propertyName = pro.getName();
            if (defaultLanguage.equals(language)) {
                node.setProperty(propertyName, (String)inputs.get(propertyName));
                continue;
            }
            if (isDefault) {
                newLanguageNode.setProperty(propertyName, node.getProperty(propertyName).getValue());
                node.setProperty(propertyName, (String)inputs.get(propertyName));
                continue;
            }
            newLanguageNode.setProperty(propertyName, (String)inputs.get(propertyName));
        }
        for (NodeType mixin : mixins = node.getMixinNodeTypes()) {
            newLanguageNode.addMixin(mixin.getName());
        }
        if (isDefault) {
            node.setProperty("exo:language", language);
        }
        node.save();
        node.getSession().save();
    }

    public void addFileLanguage(Node node, Value value, String language, boolean isDefault) throws Exception {
        NodeType[] mixins;
        Node newLanguageNode = null;
        Node languagesNode = null;
        Workspace ws = node.getSession().getWorkspace();
        String defaultLanguage = this.getDefault(node);
        languagesNode = node.hasNode("languages") ? node.getNode("languages") : node.addNode("languages", NTUNSTRUCTURED);
        if (!defaultLanguage.equals(language)) {
            Node jcrContent;
            if (isDefault) {
                newLanguageNode = languagesNode.hasNode(defaultLanguage) ? languagesNode.getNode(defaultLanguage) : languagesNode.addNode(defaultLanguage);
                jcrContent = node.getNode(JCRCONTENT);
                node.save();
                ws.copy(jcrContent.getPath(), newLanguageNode.getPath() + "/" + jcrContent.getName());
                jcrContent.setProperty(JCRDATA, value);
            } else {
                newLanguageNode = languagesNode.hasNode(language) ? languagesNode.getNode(language) : languagesNode.addNode(language);
                jcrContent = node.getNode(JCRCONTENT);
                node.save();
                ws.copy(jcrContent.getPath(), newLanguageNode.getPath() + "/" + jcrContent.getName());
                newLanguageNode.getNode(JCRCONTENT).setProperty(JCRDATA, value);
            }
        }
        for (NodeType mixin : mixins = node.getMixinNodeTypes()) {
            newLanguageNode.addMixin(mixin.getName());
        }
        if (isDefault) {
            node.setProperty("exo:language", language);
        }
        node.save();
        node.getSession().save();
    }

    public String getDefault(Node node) throws Exception {
        return node.getProperty("exo:language").getString();
    }

    public List<String> getSupportedLanguages(Node node) throws Exception {
        ArrayList<String> languages = new ArrayList<String>();
        String defaultLang = this.getDefault(node);
        languages.add(defaultLang);
        if (node.hasNode("languages")) {
            Node languageNode = node.getNode("languages");
            NodeIterator iter = languageNode.getNodes();
            while (iter.hasNext()) {
                languages.add(iter.nextNode().getName());
            }
        }
        return languages;
    }

    public void setDefault(Node node, String language) throws Exception {
        String defaultLanguage = this.getDefault(node);
        if (!defaultLanguage.equals(language)) {
            Node languagesNode = null;
            languagesNode = node.hasNode("languages") ? node.getNode("languages") : node.addNode("languages", NTUNSTRUCTURED);
            Node selectedLangNode = languagesNode.getNode(language);
            if (node.getPrimaryNodeType().getName().equals("nt:file")) {
                Value value = node.getNode(JCRCONTENT).getProperty(JCRDATA).getValue();
                Value selectedValue = selectedLangNode.getNode(JCRCONTENT).getProperty(JCRDATA).getValue();
                node.getNode(JCRCONTENT).setProperty(JCRDATA, selectedValue);
                selectedLangNode.getNode(JCRCONTENT).setProperty(JCRDATA, value);
                node.getSession().move(languagesNode.getPath() + "/" + language, languagesNode.getPath() + "/" + defaultLanguage);
                node.setProperty("exo:language", language);
            } else {
                PropertyDefinition[] properties;
                Node newLang = languagesNode.addNode(defaultLanguage);
                for (PropertyDefinition pro : properties = node.getPrimaryNodeType().getPropertyDefinitions()) {
                    if (pro.isProtected()) continue;
                    String propertyName = pro.getName();
                    newLang.setProperty(propertyName, node.getProperty(propertyName).getValue());
                    node.setProperty(propertyName, selectedLangNode.getProperty(propertyName).getValue());
                }
                node.setProperty("exo:language", language);
                selectedLangNode.remove();
            }
            node.save();
            node.getSession().save();
        }
    }

    public Node getLanguage(Node node, String language) throws Exception {
        if (node.hasNode("languages/" + language)) {
            return node.getNode("languages/" + language);
        }
        return null;
    }
}

