/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.impl;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Map;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.Workspace;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.nodetype.PropertyDefinition;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.utils.ISO8601;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.SessionContainer;
import org.exoplatform.services.cms.CmsConfigurationService;
import org.exoplatform.services.cms.CmsService;
import org.exoplatform.services.cms.JcrInputProperty;
import org.exoplatform.services.idgenerator.IDGeneratorService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.core.ManageableRepository;

public class CmsServiceImpl
implements CmsService {
    private RepositoryService jcrService;
    private CmsConfigurationService cmsConfigurationService;
    private IDGeneratorService idGeneratorService;

    public CmsServiceImpl(RepositoryService jcrService, IDGeneratorService idGeneratorService, CmsConfigurationService cmsConfigurationService) {
        this.idGeneratorService = idGeneratorService;
        this.jcrService = jcrService;
        this.cmsConfigurationService = cmsConfigurationService;
    }

    public String storeNode(String workspace, String nodeTypeName, String storePath, Map mappings) throws Exception {
        ManageableRepository repository = this.jcrService.getRepository();
        Session session = repository.login(workspace);
        Node storeHomeNode = (Node)session.getItem(storePath);
        String path = this.storeNode(nodeTypeName, storeHomeNode, mappings, true);
        storeHomeNode.save();
        return path;
    }

    public String storeNode(String nodeTypeName, Node storeHomeNode, Map mappings, boolean isAddNew) throws Exception {
        SessionContainer sessionContainer;
        String owner;
        Set keys = mappings.keySet();
        String nodePath = this.extractNodeName(keys);
        JcrInputProperty relRootProp = (JcrInputProperty)mappings.get(nodePath);
        String nodeName = (String)relRootProp.getValue();
        if (nodeName == null || nodeName.length() == 0) {
            nodeName = this.idGeneratorService.generateStringID((Object)nodeTypeName);
        }
        String string = owner = (sessionContainer = SessionContainer.getInstance()) != null ? sessionContainer.getRemoteUser() : null;
        if (owner == null || owner.length() == 0) {
            owner = "Anonymous";
        }
        Session session = storeHomeNode.getSession();
        NodeTypeManager nodetypeManager = session.getWorkspace().getNodeTypeManager();
        NodeType nodeType = nodetypeManager.getNodeType(nodeTypeName);
        Node currentNode = null;
        if (!isAddNew) {
            currentNode = storeHomeNode.getNode(nodeName);
            this.updateNodeRecursively("/node", currentNode, nodeType, mappings);
        } else {
            currentNode = storeHomeNode.addNode(nodeName, nodeTypeName);
            ExtendedNode ext = (ExtendedNode)currentNode;
            ext.getACL().setOwner(owner);
            String mixintypeName = relRootProp.getMixintype();
            if (mixintypeName != null) {
                if (mixintypeName.indexOf(",") > -1) {
                    String[] mixinTypes = mixintypeName.split(",");
                    for (int i = 0; i < mixinTypes.length; ++i) {
                        String name = mixinTypes[i].trim();
                        NodeType mixinType = nodetypeManager.getNodeType(name);
                        currentNode.addMixin(name);
                        this.createNodeRecursively("/node", currentNode, mixinType, mappings);
                    }
                } else {
                    NodeType mixinType = nodetypeManager.getNodeType(mixintypeName);
                    currentNode.addMixin(mixintypeName);
                    this.createNodeRecursively("/node", currentNode, mixinType, mappings);
                }
            }
            this.createNodeRecursively("/node", currentNode, nodeType, mappings);
        }
        return session.getWorkspace().getName() + ":" + currentNode.getPath();
    }

    private void updateNodeRecursively(String path, Node currentNode, NodeType currentNodeType, Map jcrVariables) throws Exception {
        this.processNodeRecursively(false, path, currentNode, currentNodeType, jcrVariables);
    }

    private void createNodeRecursively(String path, Node currentNode, NodeType currentNodeType, Map jcrVariables) throws Exception {
        this.processNodeRecursively(true, path, currentNode, currentNodeType, jcrVariables);
    }

    /*
     * WARNING - void declaration
     */
    private void processNodeRecursively(boolean create, String path, Node currentNode, NodeType currentNodeType, Map jcrVariables) throws Exception {
        Object value;
        JcrInputProperty inputVariable;
        String currentPath;
        int requiredtype;
        String propertyName;
        if (create) {
            PropertyDefinition[] propertyDefs = currentNodeType.getPropertyDefinitions();
            for (int i = 0; i < propertyDefs.length; ++i) {
                PropertyDefinition propertyDefinition = propertyDefs[i];
                if (propertyDefinition.isAutoCreated() || propertyDefinition.isProtected()) continue;
                propertyName = propertyDefinition.getName();
                requiredtype = propertyDefinition.getRequiredType();
                currentPath = path + "/" + propertyName;
                inputVariable = (JcrInputProperty)jcrVariables.get(currentPath);
                value = null;
                if (inputVariable != null) {
                    value = inputVariable.getValue();
                }
                if (value == null && !propertyDefinition.isMandatory()) continue;
                this.processProperty(propertyName, currentNode, requiredtype, value, propertyDefinition.isMultiple());
            }
        } else {
            PropertyIterator pi = currentNode.getProperties();
            while (pi.hasNext()) {
                Property property = pi.nextProperty();
                PropertyDefinition propertyDefinition = property.getDefinition();
                propertyName = property.getName();
                requiredtype = property.getType();
                currentPath = path + "/" + propertyName;
                inputVariable = (JcrInputProperty)jcrVariables.get(currentPath);
                value = null;
                if (inputVariable != null) {
                    value = inputVariable.getValue();
                }
                if (value == null || propertyDefinition.isProtected()) continue;
                this.processProperty(propertyName, currentNode, requiredtype, value, propertyDefinition.isMultiple());
            }
        }
        ArrayList<Object> childs = new ArrayList<Object>();
        if (create) {
            void var8_14;
            NodeDefinition[] childNodeDefs = currentNodeType.getChildNodeDefinitions();
            boolean bl = false;
            while (var8_14 < childNodeDefs.length) {
                childs.add(childNodeDefs[var8_14]);
                ++var8_14;
            }
        } else {
            NodeIterator nodes = currentNode.getNodes();
            while (nodes.hasNext()) {
                childs.add(nodes.next());
            }
        }
        for (Object e : childs) {
            Node childNode;
            NodeType nodeType;
            String nodeName;
            block19: {
                NodeDefinition nodeDef;
                if (e instanceof Node) {
                    nodeDef = ((Node)e).getDefinition();
                    nodeName = ((Node)e).getName();
                } else {
                    nodeDef = (NodeDefinition)e;
                    nodeName = ((NodeDefinition)e).getName();
                }
                if (nodeDef.isAutoCreated() || nodeDef.isProtected() || "*".equals(nodeDef.getName()) && e instanceof NodeDefinition) continue;
                currentPath = path + "/" + nodeName;
                inputVariable = (JcrInputProperty)jcrVariables.get(currentPath);
                String nodetypeName = null;
                String mixintypeName = null;
                if (inputVariable != null) {
                    nodetypeName = inputVariable.getNodetype();
                    mixintypeName = inputVariable.getMixintype();
                }
                Session session = currentNode.getSession();
                NodeTypeManager nodetypeManager = session.getWorkspace().getNodeTypeManager();
                nodeType = null;
                nodeType = e instanceof Node ? ((Node)e).getPrimaryNodeType() : (nodetypeName == null || "".equals(nodetypeName) ? nodeDef.getRequiredPrimaryTypes()[0] : nodetypeManager.getNodeType(nodetypeName));
                childNode = null;
                if (create) {
                    childNode = currentNode.addNode(nodeName, nodeType.getName());
                    if (mixintypeName != null) {
                        childNode.addMixin(mixintypeName);
                        NodeType mixinType = nodetypeManager.getNodeType(mixintypeName);
                        this.processNodeRecursively(create, path + "/" + nodeName, childNode, mixinType, jcrVariables);
                    }
                } else {
                    try {
                        childNode = currentNode.getNode(nodeName);
                    }
                    catch (PathNotFoundException e2) {
                        childNode = currentNode.addNode(nodeName, nodeType.getName());
                        if (mixintypeName == null) break block19;
                        childNode.addMixin(mixintypeName);
                        NodeType mixinType = nodetypeManager.getNodeType(mixintypeName);
                        this.processNodeRecursively(create, path + "/" + nodeName, childNode, mixinType, jcrVariables);
                    }
                }
            }
            this.processNodeRecursively(create, path + "/" + nodeName, childNode, nodeType, jcrVariables);
        }
    }

    private void processProperty(String propertyName, Node node, int requiredtype, Object value, boolean isMultiple) throws Exception {
        switch (requiredtype) {
            case 1: {
                if (value == null) {
                    node.setProperty(propertyName, "");
                    break;
                }
                if (isMultiple) {
                    if (value instanceof String) {
                        node.setProperty(propertyName, new String[]{(String)value});
                        break;
                    }
                    if (!(value instanceof String[])) break;
                    node.setProperty(propertyName, (String[])value);
                    break;
                }
                node.setProperty(propertyName, (String)value);
                break;
            }
            case 2: {
                if (value == null) {
                    node.setProperty(propertyName, "");
                    break;
                }
                if (value instanceof byte[]) {
                    node.setProperty(propertyName, (InputStream)new ByteArrayInputStream((byte[])value));
                    break;
                }
                if (value instanceof String) {
                    node.setProperty(propertyName, (InputStream)new ByteArrayInputStream(((String)value).getBytes()));
                    break;
                }
                if (!(value instanceof String[])) break;
                node.setProperty(propertyName, (InputStream)new ByteArrayInputStream(((String[])value).toString().getBytes()));
                break;
            }
            case 6: {
                if (value == null) {
                    node.setProperty(propertyName, false);
                    break;
                }
                if (value instanceof String) {
                    node.setProperty(propertyName, new Boolean((String)value).booleanValue());
                    break;
                }
                if (!(value instanceof String[])) break;
                node.setProperty(propertyName, (String[])value);
                break;
            }
            case 3: {
                if (value == null || "".equals(value)) {
                    node.setProperty(propertyName, 0L);
                    break;
                }
                if (value instanceof String) {
                    node.setProperty(propertyName, new Long((String)value).longValue());
                    break;
                }
                if (!(value instanceof String[])) break;
                node.setProperty(propertyName, (String[])value);
                break;
            }
            case 4: {
                if (value == null || "".equals(value)) {
                    node.setProperty(propertyName, 0L);
                    break;
                }
                if (value instanceof String) {
                    node.setProperty(propertyName, new Double((String)value).doubleValue());
                    break;
                }
                if (!(value instanceof String[])) break;
                node.setProperty(propertyName, (String[])value);
                break;
            }
            case 5: {
                if (value == null) {
                    node.setProperty(propertyName, (Calendar)new GregorianCalendar());
                    break;
                }
                if (isMultiple) {
                    Session session = this.jcrService.getRepository().getSystemSession(this.cmsConfigurationService.getWorkspace());
                    if (value instanceof String) {
                        Value value2add = session.getValueFactory().createValue(ISO8601.parse((String)((String)value)));
                        node.setProperty(propertyName, new Value[]{value2add});
                        break;
                    }
                    if (!(value instanceof String[])) break;
                    String[] values = (String[])value;
                    Value[] convertedCalendarValues = new Value[values.length];
                    int i = 0;
                    for (String stringValue : values) {
                        Value value2add;
                        convertedCalendarValues[i] = value2add = session.getValueFactory().createValue(ISO8601.parse((String)stringValue));
                        ++i;
                    }
                    node.setProperty(propertyName, convertedCalendarValues);
                    break;
                }
                if (value instanceof String) {
                    node.setProperty(propertyName, ISO8601.parse((String)((String)value)));
                    break;
                }
                if (!(value instanceof GregorianCalendar)) break;
                node.setProperty(propertyName, (Calendar)((GregorianCalendar)value));
                break;
            }
            case 9: {
                if (value == null) {
                    throw new RepositoryException("null value for a reference " + requiredtype);
                }
                if (value instanceof Value[]) {
                    node.setProperty(propertyName, (Value[])value);
                    break;
                }
                if (!(value instanceof String)) break;
                Session session = this.jcrService.getRepository().getSystemSession(this.cmsConfigurationService.getWorkspace());
                if (session.getRootNode().hasNode((String)value)) {
                    Node catNode = session.getRootNode().getNode((String)value);
                    Value value2add = session.getValueFactory().createValue(catNode);
                    node.setProperty(propertyName, new Value[]{value2add});
                    break;
                }
                node.setProperty(propertyName, (String)value);
                break;
            }
            default: {
                throw new RepositoryException("unknown type " + requiredtype);
            }
        }
    }

    private String extractNodeName(Set keys) {
        for (String key : keys) {
            if (!key.endsWith("/node")) continue;
            return key;
        }
        return null;
    }

    public void moveNode(String nodePath, String srcWorkspace, String destWorkspace, String destPath) {
        ExoContainer eXoContainer = ExoContainerContext.getCurrentContainer();
        RepositoryService repService = (RepositoryService)eXoContainer.getComponentInstanceOfType(RepositoryService.class);
        if (!srcWorkspace.equals(destWorkspace)) {
            try {
                ManageableRepository repository = repService.getRepository();
                Session srcSession = repository.getSystemSession(srcWorkspace);
                Session destSession = repository.getSystemSession(destWorkspace);
                Workspace workspace = destSession.getWorkspace();
                Node srcNode = (Node)srcSession.getItem(nodePath);
                try {
                    destSession.getItem(destPath);
                }
                catch (PathNotFoundException e) {
                    this.createNode(destSession, destPath);
                }
                workspace.clone(srcWorkspace, nodePath, destPath, true);
                srcNode.remove();
                srcSession.save();
                destSession.save();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            try {
                ManageableRepository repository = repService.getRepository();
                Session session = repository.getSystemSession(srcWorkspace);
                Workspace workspace = session.getWorkspace();
                try {
                    session.getItem(destPath);
                }
                catch (PathNotFoundException e) {
                    this.createNode(session, destPath);
                    session.refresh(false);
                }
                workspace.move(nodePath, destPath);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void createNode(Session session, String uri) throws RepositoryException {
        String[] splittedName = StringUtils.split((String)uri, (String)"/");
        Node rootNode = session.getRootNode();
        for (int i = 0; i < splittedName.length - 1; ++i) {
            try {
                rootNode.getNode(splittedName[i]);
            }
            catch (PathNotFoundException exc) {
                rootNode.addNode(splittedName[i], "nt:unstructured");
                rootNode.save();
            }
            rootNode = rootNode.getNode(splittedName[i]);
        }
        session.save();
    }

    public void storeMixin(Node node, String mixinNodeType) throws Exception {
        if (node.canAddMixin(mixinNodeType)) {
            node.addMixin(mixinNodeType);
        }
    }
}

