/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.impl;

import java.util.HashMap;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.services.jcr.core.ExtendedNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    public static Map<String, String[]> getReadPermissions() {
        HashMap<String, String[]> permissions = new HashMap<String, String[]>();
        permissions.put("any", new String[]{"read"});
        return permissions;
    }

    public static Node makePath(Node rootNode, String path, String nodetype) throws PathNotFoundException, RepositoryException {
        return Utils.makePath(rootNode, path, nodetype, null);
    }

    public static Node makePath(Node rootNode, String path, String nodetype, Map permissions) throws PathNotFoundException, RepositoryException {
        String[] tokens = StringUtils.split((String)path, (char)'/');
        Node node = rootNode;
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (!node.hasNode(token)) {
                node = node.addNode(token, nodetype);
                if (permissions == null) continue;
                if (node.canAddMixin("exo:privilegeable")) {
                    node.addMixin("exo:privilegeable");
                }
                ((ExtendedNode)node).setPermissions(permissions);
                continue;
            }
            node = node.getNode(token);
        }
        return node;
    }
}

