/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.metadata;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeIterator;
import javax.jcr.nodetype.NodeTypeManager;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.services.cms.CmsConfigurationService;
import org.exoplatform.services.cms.impl.Utils;
import org.exoplatform.services.cms.metadata.MetadataService;
import org.exoplatform.services.cms.templates.impl.TemplateConfig;
import org.exoplatform.services.cms.templates.impl.TemplatePlugin;
import org.exoplatform.services.jcr.RepositoryService;
import org.picocontainer.Startable;

public class MetadataServiceImpl
implements MetadataService,
Startable {
    public static final String NT_UNSTRUCTURED = "nt:unstructured";
    public static final String EXO_TEMPLATE = "exo:template";
    public static final String EXO_ROLES_PROP = "exo:roles";
    public static final String EXO_TEMPLATE_FILE_PROP = "exo:templateFile";
    public static final String DIALOGS = "dialogs";
    public static final String VIEWS = "views";
    public static final String DIALOG1 = "dialog1";
    public static final String VIEW1 = "view1";
    private RepositoryService repositoryService_;
    private CmsConfigurationService cmsConfigService_;
    private ConfigurationManager configManager_;
    private Session session_;
    private List<TemplatePlugin> plugins_;

    public MetadataServiceImpl(CmsConfigurationService cmsConfigService, RepositoryService repositoryService, ConfigurationManager configManager) throws Exception {
        this.cmsConfigService_ = cmsConfigService;
        this.repositoryService_ = repositoryService;
        this.configManager_ = configManager;
        this.plugins_ = new ArrayList<TemplatePlugin>();
    }

    public void start() {
        try {
            this.init();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void stop() {
    }

    public void addPlugins(ComponentPlugin plugin) {
        if (plugin instanceof TemplatePlugin) {
            this.plugins_.add((TemplatePlugin)plugin);
        }
    }

    private void init() throws Exception {
        this.session_ = this.repositoryService_.getRepository().getSystemSession(this.cmsConfigService_.getWorkspace());
        String metadataPath = this.cmsConfigService_.getJcrPath("metadataPath");
        Node root = this.session_.getRootNode();
        Node metadataHome = null;
        List nodetypes = null;
        for (int j = 0; j < this.plugins_.size(); ++j) {
            nodetypes = this.plugins_.get(j).getNodeTypes();
            if (nodetypes.isEmpty()) {
                return;
            }
            TemplateConfig.NodeType nodeType2 = (TemplateConfig.NodeType)nodetypes.iterator().next();
            String nodeTypeName = nodeType2.getNodetypeName();
            try {
                metadataHome = (Node)this.session_.getItem(metadataPath);
            }
            catch (PathNotFoundException e) {
                // empty catch block
            }
            String sourcePath = this.cmsConfigService_.getContentLocation() + "/system" + metadataPath.substring(metadataPath.lastIndexOf("/"));
            for (TemplateConfig.NodeType nodeType2 : nodetypes) {
                List views;
                nodeTypeName = nodeType2.getNodetypeName();
                Node nodeTypeHome = null;
                nodeTypeHome = !metadataHome.hasNode(nodeTypeName) ? Utils.makePath(metadataHome, nodeTypeName, NT_UNSTRUCTURED) : metadataHome.getNode(nodeTypeName);
                List dialogs = nodeType2.getReferencedDialog();
                if (dialogs.size() > 0) {
                    Node dialogsHome = this.createTemplateHome(nodeTypeHome, true);
                    this.addNode(sourcePath, dialogsHome, dialogs);
                }
                if ((views = nodeType2.getReferencedView()).size() <= 0) continue;
                Node viewsHome = this.createTemplateHome(nodeTypeHome, false);
                this.addNode(sourcePath, viewsHome, views);
            }
        }
        root.save();
    }

    private void addNode(String metadataPath, Node templateHome, List templates) throws Exception {
        for (TemplateConfig.Template template : templates) {
            String templateFileName = template.getTemplateFile();
            String path = metadataPath + templateFileName;
            InputStream in = this.configManager_.getInputStream(path);
            String nodeName = templateFileName.substring(templateFileName.lastIndexOf("/") + 1, templateFileName.indexOf("."));
            Node contentNode = templateHome.addNode(nodeName, EXO_TEMPLATE);
            contentNode.setProperty(EXO_ROLES_PROP, template.getParsedRoles());
            contentNode.setProperty(EXO_TEMPLATE_FILE_PROP, in);
        }
    }

    public void addMetadata(String nodetype, boolean isDialog, String role, String content, boolean isAddNew) throws Exception {
        String metadataPath = this.cmsConfigService_.getJcrPath("metadataPath");
        Node metadataHome = (Node)this.session_.getItem(metadataPath);
        if (!isAddNew) {
            if (isDialog) {
                Node dialog1 = metadataHome.getNode(nodetype).getNode(DIALOGS).getNode(DIALOG1);
                dialog1.setProperty(EXO_ROLES_PROP, role.split(";"));
                dialog1.setProperty(EXO_TEMPLATE_FILE_PROP, content);
                dialog1.save();
            } else {
                Node view1 = metadataHome.getNode(nodetype).getNode(VIEWS).getNode(VIEW1);
                view1.setProperty(EXO_ROLES_PROP, role.split(";"));
                view1.setProperty(EXO_TEMPLATE_FILE_PROP, content);
                view1.save();
            }
        } else {
            Node metadata = null;
            metadata = metadataHome.hasNode(nodetype) ? metadataHome.getNode(nodetype) : metadataHome.addNode(nodetype, NT_UNSTRUCTURED);
            this.addTemplate(metadata, role, content, isDialog);
            metadataHome.save();
        }
        this.session_.save();
    }

    private void addTemplate(Node nodetype, String role, String content, boolean isDialog) throws Exception {
        Node templateHome = this.createTemplateHome(nodetype, isDialog);
        Node template = null;
        template = isDialog ? (templateHome.hasNode(DIALOG1) ? templateHome.getNode(DIALOG1) : templateHome.addNode(DIALOG1, EXO_TEMPLATE)) : (templateHome.hasNode(VIEW1) ? templateHome.getNode(VIEW1) : templateHome.addNode(VIEW1, EXO_TEMPLATE));
        template.setProperty(EXO_ROLES_PROP, role.split(";"));
        template.setProperty(EXO_TEMPLATE_FILE_PROP, content);
    }

    public void removeMetadata(String nodetype) throws Exception {
        String metadataPath = this.cmsConfigService_.getJcrPath("metadataPath");
        Node metadataHome = (Node)this.session_.getItem(metadataPath);
        Node metadata = metadataHome.getNode(nodetype);
        metadata.remove();
        metadataHome.save();
        this.session_.save();
    }

    public List getMetadataList() throws Exception {
        ArrayList<String> metadatas = new ArrayList<String>();
        this.session_.refresh(true);
        String metadataPath = this.cmsConfigService_.getJcrPath("metadataPath");
        Node metadataHome = (Node)this.session_.getItem(metadataPath);
        NodeIterator iter = metadataHome.getNodes();
        while (iter.hasNext()) {
            metadatas.add(iter.nextNode().getName());
        }
        return metadatas;
    }

    private Node createTemplateHome(Node nodetype, boolean isDialog) throws Exception {
        if (isDialog) {
            Node dialogs = null;
            dialogs = nodetype.hasNode(DIALOGS) ? nodetype.getNode(DIALOGS) : nodetype.addNode(DIALOGS, NT_UNSTRUCTURED);
            return dialogs;
        }
        Node views = null;
        views = nodetype.hasNode(VIEWS) ? nodetype.getNode(VIEWS) : nodetype.addNode(VIEWS, NT_UNSTRUCTURED);
        return views;
    }

    public String getMetadataTemplate(String name, boolean isDialog) throws Exception {
        String metadataPath = this.cmsConfigService_.getJcrPath("metadataPath");
        Node metadataHome = (Node)this.session_.getItem(metadataPath);
        Node template = null;
        template = isDialog ? metadataHome.getNode(name).getNode(DIALOGS).getNode(DIALOG1) : metadataHome.getNode(name).getNode(VIEWS).getNode(VIEW1);
        return template.getProperty(EXO_TEMPLATE_FILE_PROP).getString();
    }

    public String getMetadataPath(String name, boolean isDialog) throws Exception {
        String metadataPath = this.cmsConfigService_.getJcrPath("metadataPath");
        Node metadataHome = (Node)this.session_.getItem(metadataPath);
        Node template = null;
        template = isDialog ? metadataHome.getNode(name).getNode(DIALOGS).getNode(DIALOG1) : metadataHome.getNode(name).getNode(VIEWS).getNode(VIEW1);
        return template.getPath();
    }

    public String getMetadataRoles(String name, boolean isDialog) throws Exception {
        String metadataPath = this.cmsConfigService_.getJcrPath("metadataPath");
        Node metadataHome = (Node)this.session_.getItem(metadataPath);
        Node template = null;
        template = isDialog ? metadataHome.getNode(name).getNode(DIALOGS).getNode(DIALOG1) : metadataHome.getNode(name).getNode(VIEWS).getNode(VIEW1);
        Value[] values = template.getProperty(EXO_ROLES_PROP).getValues();
        StringBuffer roles = new StringBuffer();
        for (int i = 0; i < values.length; ++i) {
            if (roles.length() > 0) {
                roles.append("; ");
            }
            roles.append(values[i].getString());
        }
        return roles.toString();
    }

    public List getMixinNodeTypes() throws Exception {
        ArrayList<String> mixinNodetypes = new ArrayList<String>();
        NodeTypeManager ntManager_ = this.session_.getWorkspace().getNodeTypeManager();
        NodeTypeIterator ntIter = ntManager_.getAllNodeTypes();
        while (ntIter.hasNext()) {
            NodeType nt = ntIter.nextNodeType();
            if (!nt.isMixin()) continue;
            mixinNodetypes.add(nt.getName());
        }
        return mixinNodetypes;
    }

    public boolean hasMetadata(String name) throws Exception {
        String metadataPath = this.cmsConfigService_.getJcrPath("metadataPath");
        Node metadataHome = (Node)this.session_.getItem(metadataPath);
        return metadataHome.hasNode(name);
    }
}

