/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.queries;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.cms.CmsConfigurationService;
import org.exoplatform.services.cms.impl.Utils;
import org.exoplatform.services.cms.queries.NewUserConfig;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserEventListener;

public class NewUserListener
extends UserEventListener {
    private static final String[] perms = new String[]{"read", "add_node", "set_property", "remove"};
    private NewUserConfig config_;
    private RepositoryService jcrService_;
    private CmsConfigurationService cmsConfigurationService_;
    private String relativePath_;

    public NewUserListener(RepositoryService jcrService, CmsConfigurationService cmsConfigurationService, InitParams params) throws Exception {
        this.jcrService_ = jcrService;
        this.cmsConfigurationService_ = cmsConfigurationService;
        this.config_ = (NewUserConfig)params.getObjectParamValues(NewUserConfig.class).get(0);
        this.relativePath_ = params.getValueParam("relativePath").getValue();
    }

    public void preSave(User user, boolean isNew) throws Exception {
        String userName = user.getUserName();
        this.prepareSystemWorkspace(userName);
    }

    private void prepareSystemWorkspace(String userName) throws Exception {
        ManageableRepository jcrRepository = this.jcrService_.getRepository();
        Session session = null;
        try {
            session = jcrRepository.getSystemSession(this.cmsConfigurationService_.getWorkspace());
        }
        catch (RepositoryException re) {
            return;
        }
        Node usersHome = (Node)session.getItem(this.cmsConfigurationService_.getJcrPath("usersPath"));
        Node userHome = Utils.makePath(usersHome, userName, "nt:unstructured", this.getPermissions(userName));
        if (userHome.hasNode(this.relativePath_)) {
            session.refresh(false);
            return;
        }
        Node queriesHome = Utils.makePath(userHome, this.relativePath_, "nt:unstructured", this.getQueryPermissions(userName));
        List users = this.config_.getUsers();
        boolean userFound = false;
        NewUserConfig.User templateConfig = null;
        for (NewUserConfig.User userConfig : users) {
            String currentName = userConfig.getUserName();
            if (this.config_.getTemplate().equals(currentName)) {
                templateConfig = userConfig;
            }
            if (!currentName.equals(userName)) continue;
            List queries = userConfig.getQueries();
            this.importQueries(queriesHome, queries);
            userFound = true;
            break;
        }
        if (!userFound) {
            List queries = templateConfig.getQueries();
            this.importQueries(queriesHome, queries);
        }
        usersHome.save();
    }

    public Map getPermissions(String owner) {
        HashMap<String, String[]> permissions = new HashMap<String, String[]>();
        permissions.put(owner, perms);
        permissions.put("any", new String[]{"read"});
        permissions.put("*:/admin", perms);
        return permissions;
    }

    public Map getQueryPermissions(String owner) {
        HashMap<String, String[]> permissions = new HashMap<String, String[]>();
        permissions.put(owner, perms);
        permissions.put("*:/admin", perms);
        return permissions;
    }

    public void importQueries(Node queriesHome, List queries) throws Exception {
        QueryManager manager = queriesHome.getSession().getWorkspace().getQueryManager();
        for (NewUserConfig.Query query : queries) {
            String queryName = query.getQueryName();
            String language = query.getLanguage();
            String statement = query.getQuery();
            Query queryNode = manager.createQuery(statement, language);
            String absPath = queriesHome.getPath() + "/" + queryName;
            queryNode.storeAsNode(absPath);
        }
    }

    public void preDelete(User user) {
    }
}

