/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.relations;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.Session;
import javax.jcr.Value;
import org.exoplatform.services.cms.CmsConfigurationService;
import org.exoplatform.services.cms.relations.RelationsService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.picocontainer.Startable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelationsServiceImpl
implements RelationsService,
Startable {
    private static final String RELATION_MIXIN = "exo:relationable";
    private static final String RELATION_PROP = "exo:relation";
    private RepositoryService repositoryService_;
    private CmsConfigurationService cmsConfig_;

    public RelationsServiceImpl(RepositoryService repositoryService, CmsConfigurationService cmsConfig) {
        this.repositoryService_ = repositoryService;
        this.cmsConfig_ = cmsConfig;
    }

    public boolean hasRelations(Node node) throws Exception {
        return node.isNodeType(RELATION_MIXIN);
    }

    public List<Node> getRelations(Node node) {
        ArrayList<Node> rels = new ArrayList<Node>();
        try {
            Session session = this.getSystemSession();
            Property relations = null;
            try {
                relations = node.getProperty(RELATION_PROP);
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (relations != null) {
                Value[] values = relations.getValues();
                for (int i = 0; i < values.length; ++i) {
                    rels.add(session.getNodeByUUID(values[i].getString()));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rels;
    }

    public void removeRelation(Node node, String relationPath) throws Exception {
        ArrayList<Value> vals = new ArrayList<Value>();
        if (!"*".equals(relationPath)) {
            Session session = this.getSystemSession();
            Property relations = node.getProperty(RELATION_PROP);
            if (relations != null) {
                Value[] values = relations.getValues();
                String uuid2Remove = null;
                for (int i = 0; i < values.length; ++i) {
                    String uuid = values[i].getString();
                    Node refNode = session.getNodeByUUID(uuid);
                    if (refNode.getPath().equals(relationPath)) {
                        uuid2Remove = uuid;
                        continue;
                    }
                    vals.add(values[i]);
                }
                if (uuid2Remove == null) {
                    return;
                }
            }
        }
        node.setProperty(RELATION_PROP, vals.toArray(new Value[vals.size()]));
    }

    public void addRelation(Node node, String relationPath) throws Exception {
        Session session = this.getSystemSession();
        Session userSession = node.getSession();
        Node catNode = (Node)session.getItem(relationPath);
        if (!catNode.isNodeType("mix:referenceable")) {
            catNode.addMixin("mix:referenceable");
            catNode.save();
        }
        Value value2add = userSession.getValueFactory().createValue(catNode);
        if (!node.isNodeType(RELATION_MIXIN)) {
            node.addMixin(RELATION_MIXIN);
            node.setProperty(RELATION_PROP, new Value[]{value2add});
        } else {
            ArrayList<Value> vals = new ArrayList<Value>();
            Value[] values = node.getProperty(RELATION_PROP).getValues();
            for (int i = 0; i < values.length; ++i) {
                Value value = values[i];
                String uuid = value.getString();
                Node refNode = session.getNodeByUUID(uuid);
                if (refNode.getPath().equals(relationPath)) {
                    return;
                }
                vals.add(value);
            }
            vals.add(value2add);
            node.setProperty(RELATION_PROP, vals.toArray(new Value[vals.size()]));
            userSession.save();
            userSession.refresh(true);
        }
    }

    public void addRelation(Node node, String relationPath, boolean replaceAll) throws Exception {
        if (replaceAll) {
            this.removeRelation(node, "*");
        }
        this.addRelation(node, relationPath);
    }

    public void start() {
        Session session = null;
        Node relationsHome = null;
        String relationPath = "";
        try {
            relationPath = this.cmsConfig_.getJcrPath("cmsPublicationsPath");
            session = this.getSystemSession();
            relationsHome = (Node)session.getItem(relationPath);
            NodeIterator iterator = relationsHome.getNodes();
            while (iterator.hasNext()) {
                Node rel = iterator.nextNode();
                rel.addMixin("mix:referenceable");
            }
            relationsHome.save();
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void stop() {
    }

    protected Session getSystemSession() throws Exception {
        ManageableRepository jcrRepository = this.repositoryService_.getRepository();
        return jcrRepository.getSystemSession(this.cmsConfig_.getWorkspace());
    }
}

