/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.scripts;

import groovy.lang.GroovyClassLoader;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.Session;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import javax.jcr.observation.ObservationManager;
import org.codehaus.groovy.control.CompilationFailedException;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cms.BasePath;
import org.exoplatform.services.cms.CmsConfigurationService;
import org.exoplatform.services.cms.impl.BaseResourceLoaderService;
import org.exoplatform.services.cms.scripts.CmsScript;
import org.exoplatform.services.cms.scripts.ScriptPlugin;
import org.exoplatform.services.cms.scripts.ScriptService;
import org.exoplatform.services.jcr.RepositoryService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptServiceImpl
extends BaseResourceLoaderService
implements ScriptService,
EventListener {
    private GroovyClassLoader groovyClassLoader_;
    private RepositoryService repositoryService_;
    List<ScriptPlugin> plugins_ = new ArrayList<ScriptPlugin>();

    public ScriptServiceImpl(RepositoryService repositoryService, CmsConfigurationService cmsConfigService, ConfigurationManager cservice, CacheService cacheService) throws Exception {
        super(null, cservice, cmsConfigService, repositoryService, cacheService);
        this.groovyClassLoader_ = this.createGroovyClassLoader();
        this.repositoryService_ = repositoryService;
    }

    @Override
    public void start() {
        try {
            this.initPlugins();
            this.initObserver();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addScriptPlugin(ComponentPlugin plugin) {
        if (plugin instanceof ScriptPlugin) {
            this.plugins_.add((ScriptPlugin)plugin);
        }
    }

    private void initPlugins() throws Exception {
        for (ScriptPlugin plugin : this.plugins_) {
            this.config_ = plugin.getScripts();
            this.init(this.config_);
        }
    }

    @Override
    protected String getBasePath() {
        return this.cmsConfigService_.getJcrPath(BasePath.CMS_SCRIPTS_PATH);
    }

    private void initObserver() throws Exception {
        String scriptsPath = this.getBasePath();
        ObservationManager obsManager = this.getSystemSession(this.config_.getWorkspace()).getWorkspace().getObservationManager();
        obsManager.addEventListener((EventListener)this, 16, scriptsPath, true, null, null, true);
    }

    public Node getECMScriptHome() throws Exception {
        Node ecmScriptHome = null;
        try {
            ecmScriptHome = this.getScriptHome(BasePath.ECM_EXPLORER_SCRIPTS);
        }
        catch (Exception e) {
            Session session = this.repositoryService_.getRepository().getSystemSession(this.cmsConfigService_.getWorkspace());
            String cbScriptHomePath = this.cmsConfigService_.getJcrPath(BasePath.ECM_EXPLORER_SCRIPTS);
            ecmScriptHome = (Node)session.getItem(cbScriptHomePath);
        }
        if (ecmScriptHome == null) {
            throw new ItemNotFoundException();
        }
        return ecmScriptHome;
    }

    public Node getCBScriptHome() throws Exception {
        Node cbHomeNode = null;
        try {
            cbHomeNode = this.getScriptHome(BasePath.CONTENT_BROWSER_SCRIPTS);
        }
        catch (Exception e) {
            Session session = this.repositoryService_.getRepository().getSystemSession(this.cmsConfigService_.getWorkspace());
            String cbScriptHomePath = this.cmsConfigService_.getJcrPath(BasePath.CONTENT_BROWSER_SCRIPTS);
            cbHomeNode = (Node)session.getItem(cbScriptHomePath);
        }
        if (cbHomeNode == null) {
            throw new ItemNotFoundException();
        }
        return cbHomeNode;
    }

    public boolean hasCBScript() throws Exception {
        return this.getCBScriptHome().hasNodes();
    }

    public List<Node> getCBScripts() throws Exception {
        ArrayList<Node> scriptList = new ArrayList<Node>();
        Node cbScriptHome = this.getCBScriptHome();
        NodeIterator iter = cbScriptHome.getNodes();
        while (iter.hasNext()) {
            scriptList.add(iter.nextNode());
        }
        return scriptList;
    }

    public Node getECMActionScriptHome() throws Exception {
        Node actionScriptHome = null;
        try {
            actionScriptHome = this.getScriptHome(BasePath.ECM_ACTION_SCRIPTS);
        }
        catch (Exception e) {
            Session session = this.repositoryService_.getRepository().getSystemSession(this.cmsConfigService_.getWorkspace());
            String actionScriptHomePath = this.cmsConfigService_.getJcrPath(BasePath.ECM_ACTION_SCRIPTS);
            actionScriptHome = (Node)session.getItem(actionScriptHomePath);
        }
        if (actionScriptHome == null) {
            throw new ItemNotFoundException();
        }
        return actionScriptHome;
    }

    public List<Node> getECMActionScripts() throws Exception {
        return this.getScriptList(BasePath.ECM_ACTION_SCRIPTS);
    }

    public Node getECMInterceptorScriptHome() throws Exception {
        Node interceptorScriptHome = null;
        try {
            interceptorScriptHome = this.getScriptHome(BasePath.ECM_INTERCEPTOR_SCRIPTS);
        }
        catch (Exception e) {
            Session session = this.repositoryService_.getRepository().getSystemSession(this.cmsConfigService_.getWorkspace());
            String actionScriptHomePath = this.cmsConfigService_.getJcrPath(BasePath.ECM_INTERCEPTOR_SCRIPTS);
            interceptorScriptHome = (Node)session.getItem(actionScriptHomePath);
        }
        if (interceptorScriptHome == null) {
            throw new ItemNotFoundException();
        }
        return interceptorScriptHome;
    }

    public List<Node> getECMInterceptorScripts() throws Exception {
        return this.getScriptList(BasePath.ECM_INTERCEPTOR_SCRIPTS);
    }

    public Node getECMWidgetScriptHome() throws Exception {
        return this.getScriptHome(BasePath.ECM_WIDGET_SCRIPTS);
    }

    public List<Node> getECMWidgetScripts() throws Exception {
        return this.getScriptList(BasePath.ECM_WIDGET_SCRIPTS);
    }

    public String getBaseScriptPath() throws Exception {
        return this.getBasePath();
    }

    public String[] getECMCategoriesPath() throws Exception {
        String[] categoriesPath = new String[]{this.cmsConfigService_.getJcrPath(BasePath.ECM_ACTION_SCRIPTS), this.cmsConfigService_.getJcrPath(BasePath.ECM_INTERCEPTOR_SCRIPTS), this.cmsConfigService_.getJcrPath(BasePath.ECM_WIDGET_SCRIPTS)};
        return categoriesPath;
    }

    public String[] getCBCategoriesPath() throws Exception {
        String[] categoriesPath = new String[]{this.cmsConfigService_.getJcrPath(BasePath.CONTENT_BROWSER_SCRIPTS)};
        return categoriesPath;
    }

    public String getScriptAsText(String scriptName) throws Exception {
        return this.getResourceAsText(scriptName);
    }

    public CmsScript getScript(String scriptName) throws Exception {
        CmsScript scriptObject = (CmsScript)this.resourceCache_.get((Serializable)((Object)scriptName));
        if (scriptObject != null) {
            return scriptObject;
        }
        ExoContainer exoContainer = ExoContainerContext.getCurrentContainer();
        scriptObject = (CmsScript)exoContainer.getComponentInstance((Object)scriptName);
        if (scriptObject != null) {
            this.resourceCache_.put((Serializable)((Object)scriptName), (Object)scriptObject);
            return scriptObject;
        }
        this.groovyClassLoader_ = this.createGroovyClassLoader();
        Class scriptClass = this.groovyClassLoader_.loadClass(scriptName);
        exoContainer.registerComponentImplementation((Object)scriptName, scriptClass);
        scriptObject = (CmsScript)exoContainer.getComponentInstance((Object)scriptName);
        this.resourceCache_.put((Serializable)((Object)scriptName), (Object)scriptObject);
        return scriptObject;
    }

    public void addScript(String name, String text) throws Exception {
        this.addResource(name, text);
        this.removeFromCache(name);
    }

    public void removeScript(String scriptName) throws Exception {
        this.removeResource(scriptName);
        this.removeFromCache(scriptName);
    }

    private Node getScriptHome(String scriptAlias) throws Exception {
        String path = this.cmsConfigService_.getJcrPath(scriptAlias);
        Session session = this.repositoryService_.getRepository().login(this.cmsConfigService_.getWorkspace());
        return (Node)session.getItem(path);
    }

    private List<Node> getScriptList(String scriptAlias) throws Exception {
        ArrayList<Node> scriptList = new ArrayList<Node>();
        Node scriptHome = this.getScriptHome(scriptAlias);
        NodeIterator iter = scriptHome.getNodes();
        while (iter.hasNext()) {
            scriptList.add(iter.nextNode());
        }
        return scriptList;
    }

    @Override
    protected void removeFromCache(String scriptName) {
        try {
            Object cachedobject = this.resourceCache_.get((Serializable)((Object)scriptName));
            if (cachedobject != null) {
                this.resourceCache_.remove((Serializable)((Object)scriptName));
                ExoContainer exoContainer = ExoContainerContext.getCurrentContainer();
                exoContainer.unregisterComponent((Object)scriptName);
                Class scriptClass = (Class)cachedobject;
                this.groovyClassLoader_.removeFromCache(scriptClass);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void onEvent(EventIterator events) {
        while (events.hasNext()) {
            Event event = events.nextEvent();
            String path = null;
            try {
                path = event.getPath();
                Session jcrSession = this.getSystemSession(this.config_.getWorkspace());
                Property property = (Property)jcrSession.getItem(path);
                if (!"jcr:data".equals(property.getName())) continue;
                Node node = property.getParent();
                this.removeFromCache(node.getName());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private GroovyClassLoader createGroovyClassLoader() {
        ClassLoader parentLoader = Thread.currentThread().getContextClassLoader();
        return new GroovyClassLoader(parentLoader){

            protected Class findClass(String className) throws ClassNotFoundException {
                String filename = className.replace('.', File.separatorChar) + ".groovy";
                InputStream in = null;
                try {
                    Node scriptsHome = ScriptServiceImpl.this.getResourcesHome();
                    Node scriptNode = scriptsHome.getNode(className);
                    in = scriptNode.getProperty("jcr:data").getStream();
                }
                catch (Exception e) {
                    throw new ClassNotFoundException("Could not read " + className + ": " + e);
                }
                try {
                    return this.parseClass(in, filename);
                }
                catch (CompilationFailedException e2) {
                    throw new ClassNotFoundException("Syntax error in " + filename + ": " + (Object)((Object)e2));
                }
            }
        };
    }

    public Node getScriptNode(String scriptName) throws Exception {
        try {
            Node scriptHome = this.getResourcesHome();
            return scriptHome.getNode(scriptName);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

