/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.views.impl;

import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.Session;
import org.exoplatform.container.component.BaseComponentPlugin;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ObjectParameter;
import org.exoplatform.services.cms.CmsConfigurationService;
import org.exoplatform.services.cms.views.impl.TemplateDataImpl;
import org.exoplatform.services.cms.views.impl.ViewDataImpl;
import org.exoplatform.services.jcr.RepositoryService;

public class ManageViewPlugin
extends BaseComponentPlugin {
    private static String CB_PATH_TEMPLATE = "pathTemplate".intern();
    private static String CB_QUERY_TEMPLATE = "queryTemplate".intern();
    private static String CB_DETAIL_VIEW_TEMPLATE = "detailViewTemplate".intern();
    private static String CB_SCRIPT_TEMPLATE = "scriptTemplate".intern();
    private static String ECM_EXPLORER_TEMPLATE = "ecmExplorerTemplate".intern();
    private RepositoryService repositoryService_;
    private ConfigurationManager cservice_;
    private CmsConfigurationService cmsConfigService_;
    private InitParams params_;
    private String warViewPath_;
    private Session session_;

    public ManageViewPlugin(RepositoryService repositoryService, InitParams params, ConfigurationManager cservice, CmsConfigurationService cmsConfigService) throws Exception {
        this.repositoryService_ = repositoryService;
        this.cservice_ = cservice;
        this.cmsConfigService_ = cmsConfigService;
        this.session_ = this.repositoryService_.getRepository().getSystemSession(this.cmsConfigService_.getWorkspace());
        this.params_ = params;
        this.initRepository();
    }

    private void initRepository() throws Exception {
        Iterator it = this.params_.getObjectParamIterator();
        String viewsPath = this.cmsConfigService_.getJcrPath("userViewsPath");
        String templatesPath = this.cmsConfigService_.getJcrPath("viewTemplatesPath");
        Node viewManager = (Node)this.session_.getItem(viewsPath);
        Node templates = (Node)this.session_.getItem(templatesPath);
        this.warViewPath_ = this.cmsConfigService_.getContentLocation() + "/system" + templatesPath.substring(templatesPath.lastIndexOf("exo:ecm") + 7);
        while (it.hasNext()) {
            Object object = ((ObjectParameter)it.next()).getObject();
            ViewDataImpl data = null;
            TemplateDataImpl temp = null;
            if (object instanceof ViewDataImpl) {
                data = (ViewDataImpl)object;
                String nodeName = data.getName();
                if (!viewManager.hasNode(nodeName)) {
                    Node view = this.addView(viewManager, nodeName, data.getPermissions(), data.getTemplate());
                    List tabList = data.getTabList();
                    for (ViewDataImpl.Tab tab : tabList) {
                        this.addTab(view, tab.getTabName(), tab.getButtons());
                    }
                }
            } else {
                temp = (TemplateDataImpl)object;
                this.addTemplate(temp);
            }
            viewManager.save();
            templates.save();
        }
        this.session_.save();
    }

    public Node addView(Node viewManager, String name, String permissions, String template) throws Exception {
        Node contentNode = viewManager.addNode(name, "exo:view");
        contentNode.setProperty("exo:permissions", permissions);
        contentNode.setProperty("exo:template", template);
        viewManager.save();
        return contentNode;
    }

    public void addTab(Node view, String name, String buttons) throws Exception {
        Node tab = view.hasNode(name) ? view.getNode(name) : view.addNode(name, "exo:tab");
        tab.setProperty("exo:buttons", buttons);
        view.save();
    }

    private void addTemplate(TemplateDataImpl tempObject) throws Exception {
        String name = tempObject.getName();
        String type = tempObject.getTemplateType();
        String alias = "";
        if (type.equals(ECM_EXPLORER_TEMPLATE)) {
            alias = "ecmExplorerTemplates";
        } else if (type.equals(CB_PATH_TEMPLATE)) {
            alias = "cbPathTemplates";
        } else if (type.equals(CB_QUERY_TEMPLATE)) {
            alias = "cbQueryTemplates";
        } else if (type.equals(CB_SCRIPT_TEMPLATE)) {
            alias = "cbScriptTemplates";
        } else if (type.equals(CB_DETAIL_VIEW_TEMPLATE)) {
            alias = "cbDetaiViewTemplates";
        }
        String templateHomePath = this.cmsConfigService_.getJcrPath(alias);
        Node templateHomeNode = (Node)this.session_.getItem(templateHomePath);
        if (templateHomeNode.hasNode(name)) {
            return;
        }
        String warPath = this.warViewPath_ + tempObject.getWarPath();
        InputStream in = this.cservice_.getInputStream(warPath);
        Node templateNode = templateHomeNode.addNode(name, "exo:template");
        templateNode.setProperty("exo:templateFile", in);
        templateHomeNode.save();
    }
}

