/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.views.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PortalContainerInfo;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.cms.CmsConfigurationService;
import org.exoplatform.services.cms.drives.ManageDriveService;
import org.exoplatform.services.cms.views.ManageViewService;
import org.exoplatform.services.cms.views.impl.ManageViewPlugin;
import org.exoplatform.services.cms.views.impl.ViewDataImpl;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.templates.velocity.impl.JCRResourceLoaderImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManageViewServiceImpl
implements ManageViewService {
    protected static final String EXO_TEMPLATE = "exo:template".intern();
    protected static final String TEMPLATE_PROP = "exo:templateFile".intern();
    protected static final String ADMIN_VIEW = "admin".intern();
    protected static final String DEFAULT_VIEW = "default".intern();
    protected static final String EXO_PERMISSIONS = "exo:permissions".intern();
    protected static final String BUTTON_PROP = "exo:buttons".intern();
    private ManageViewPlugin viewPlugin_;
    private String buttons_;
    private RepositoryService jcrService_;
    private CmsConfigurationService cmsConfigurationService_;
    private Session session_;
    private PortalContainerInfo containerInfo_;
    private CacheService cacheService_;

    public ManageViewServiceImpl(InitParams params, RepositoryService jcrService, CmsConfigurationService cmsConfigurationService, ManageDriveService dservice, PortalContainerInfo containerInfo, CacheService cacheService) throws Exception {
        this.containerInfo_ = containerInfo;
        this.cacheService_ = cacheService;
        this.jcrService_ = jcrService;
        this.cmsConfigurationService_ = cmsConfigurationService;
        ValueParam buttonParam = params.getValueParam("buttons");
        this.buttons_ = buttonParam.getValue();
        ManageableRepository jcrRepository = this.jcrService_.getRepository();
        this.session_ = jcrRepository.getSystemSession(this.cmsConfigurationService_.getWorkspace());
    }

    public void setManageViewPlugin(ManageViewPlugin viewPlugin) {
        this.viewPlugin_ = viewPlugin;
    }

    public List getButtons() {
        if (this.buttons_ == null || this.buttons_.length() < 1) {
            return null;
        }
        ArrayList<String> buttonList = new ArrayList<String>();
        if (this.buttons_.indexOf(";") > -1) {
            String[] buttons = StringUtils.split((String)this.buttons_, (String)";");
            if (buttons == null || buttons.length < 1) {
                return null;
            }
            for (int i = 0; i < buttons.length; ++i) {
                buttonList.add(buttons[i].trim());
            }
        } else {
            buttonList.add(this.buttons_);
        }
        return buttonList;
    }

    public Node getViewHome() throws Exception {
        String viewsPath = this.cmsConfigurationService_.getJcrPath("userViewsPath");
        return (Node)this.session_.getItem(viewsPath);
    }

    public List getAllViews() throws Exception {
        Node viewHome;
        Session session;
        ArrayList<ViewDataImpl> viewList = new ArrayList<ViewDataImpl>();
        String viewsPath = this.cmsConfigurationService_.getJcrPath("userViewsPath");
        try {
            session = this.getUserSession();
            viewHome = (Node)session.getItem(viewsPath);
        }
        catch (Exception ex) {
            session = this.jcrService_.getRepository().getSystemSession(this.cmsConfigurationService_.getWorkspace());
            viewHome = (Node)session.getItem(viewsPath);
        }
        NodeIterator iter = viewHome.getNodes();
        while (iter.hasNext()) {
            ViewDataImpl view = new ViewDataImpl();
            Node viewNode = iter.nextNode();
            view.setName(viewNode.getName());
            view.setPermissions(viewNode.getProperty(EXO_PERMISSIONS).getString());
            view.setTemplate(viewNode.getProperty(EXO_TEMPLATE).getString());
            ArrayList<String> tabList = new ArrayList<String>();
            NodeIterator tabsIterator = viewNode.getNodes();
            while (tabsIterator.hasNext()) {
                tabList.add(tabsIterator.nextNode().getName());
            }
            view.setTabList(tabList);
            viewList.add(view);
        }
        return viewList;
    }

    public boolean hasView(String name) throws Exception {
        Node viewHome = this.getViewHome();
        return viewHome.hasNode(name);
    }

    public Node getViewByName(String name) throws Exception {
        Node selectedView = this.getViewHome().getNode(name);
        return selectedView;
    }

    public Node getDefaultView() throws Exception {
        return this.getViewHome().getNode(DEFAULT_VIEW);
    }

    public Node getAdminView() throws Exception {
        return this.getViewHome().getNode(ADMIN_VIEW);
    }

    public void addView(String name, String permissions, String template, List tabs) throws Exception {
        Node view;
        Node viewHome = this.getViewHome();
        if (viewHome.hasNode(name)) {
            view = viewHome.getNode(name);
            view.setProperty(EXO_PERMISSIONS, permissions);
            view.setProperty(EXO_TEMPLATE, template);
        } else {
            view = this.viewPlugin_.addView(viewHome, name, permissions, template);
        }
        for (int i = 0; i < tabs.size(); ++i) {
            String buttons;
            String tabName;
            try {
                Node tab = (Node)tabs.get(i);
                tabName = tab.getName();
                buttons = tab.getProperty(BUTTON_PROP).getString();
            }
            catch (Exception e) {
                ViewDataImpl.Tab tab = (ViewDataImpl.Tab)tabs.get(i);
                tabName = tab.getTabName();
                buttons = tab.getButtons();
            }
            this.viewPlugin_.addTab(view, tabName, buttons);
        }
        viewHome.save();
    }

    public List<Node> getAllViewByPermission(String permission) throws Exception {
        ArrayList<Node> viewsByPermission = new ArrayList<Node>();
        NodeIterator iter = this.getViewHome().getNodes();
        while (iter.hasNext()) {
            Node view = iter.nextNode();
            String permissions = view.getProperty(EXO_PERMISSIONS).getString();
            if (permissions.indexOf(permission) <= -1) continue;
            viewsByPermission.add(view);
        }
        return viewsByPermission;
    }

    public void removeView(String viewName) throws Exception {
        Node viewHome = this.getViewHome();
        if (viewHome.hasNode(viewName)) {
            Node view = viewHome.getNode(viewName);
            view.remove();
            viewHome.save();
            this.session_.save();
            this.session_.refresh(true);
        }
    }

    public void addTab(Node view, String name, String buttons) throws Exception {
        this.viewPlugin_.addTab(view, name, buttons);
    }

    public Node getTemplateHome(String homeAlias) throws Exception {
        String homePath = this.getJCRPath(homeAlias);
        try {
            Session session = this.getUserSession();
            return (Node)session.getItem(homePath);
        }
        catch (Exception e) {
            return (Node)this.session_.getItem(homePath);
        }
    }

    private String getJCRPath(String jcrAlias) throws Exception {
        return this.cmsConfigurationService_.getJcrPath(jcrAlias);
    }

    private Session getUserSession() throws Exception {
        try {
            return this.jcrService_.getRepository().login(this.cmsConfigurationService_.getWorkspace());
        }
        catch (Exception e) {
            return this.session_;
        }
    }

    public List<Node> getAllTemplates(String homeAlias) throws Exception {
        Node templateHomNode = this.getTemplateHome(homeAlias);
        ArrayList<Node> list = new ArrayList<Node>();
        NodeIterator iter = templateHomNode.getNodes();
        while (iter.hasNext()) {
            list.add(iter.nextNode());
        }
        return list;
    }

    public Node getTemplate(String path) throws Exception {
        Session session = this.getUserSession();
        return (Node)session.getItem(path);
    }

    public void addTemplate(String name, String content, String homeTemplate) throws Exception {
        Session session = this.getUserSession();
        Node templateHome = (Node)session.getItem(homeTemplate);
        Node newTemp = null;
        newTemp = templateHome.hasNode(name) ? templateHome.getNode(name) : templateHome.addNode(name, EXO_TEMPLATE);
        newTemp.setProperty(TEMPLATE_PROP, content);
        templateHome.save();
        this.removeFromCache(newTemp.getPath());
    }

    public void removeTemplate(String templatePath) throws Exception {
        Session session = this.getUserSession();
        Node selectedTemplate = (Node)session.getItem(templatePath);
        Node parent = selectedTemplate.getParent();
        String path = selectedTemplate.getPath();
        selectedTemplate.remove();
        parent.save();
        session.save();
        this.removeFromCache(path);
    }

    protected void removeFromCache(String templateName) {
        try {
            ExoCache jcrcache_ = this.cacheService_.getCacheInstance(JCRResourceLoaderImpl.class.getName());
            String portalName = this.containerInfo_.getContainerName();
            String key = portalName + "jcr:" + templateName;
            Object cachedobject = jcrcache_.get((Serializable)((Object)key));
            if (cachedobject != null) {
                jcrcache_.remove((Serializable)((Object)key));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

