/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.voting.impl;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import javax.jcr.Node;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import org.exoplatform.container.SessionContainer;
import org.exoplatform.services.cms.voting.VotingService;

public class VotingServiceImpl
implements VotingService {
    static final String VOTABLE = "mix:votable".intern();
    static final String VOTER_PROP = "exo:voter".intern();
    static final String VOTING_RATE_PROP = "exo:votingRate".intern();
    static final String VOTE_TOTAL_PROP = "exo:voteTotal".intern();

    public void vote(Node document, double rate) throws Exception {
        if (!document.isNodeType(VOTABLE)) {
            if (document.canAddMixin(VOTABLE)) {
                document.addMixin(VOTABLE);
            } else {
                throw new NoSuchNodeTypeException();
            }
        }
        Session session = document.getSession();
        long voteTotal = document.getProperty(VOTE_TOTAL_PROP).getLong();
        double votingRate = document.getProperty(VOTING_RATE_PROP).getDouble();
        double newRating = ((double)voteTotal * votingRate + rate) / (double)(voteTotal + 1L);
        DecimalFormat format = new DecimalFormat("###.##");
        double fomatedRating = format.parse(format.format(newRating)).doubleValue();
        String userId = SessionContainer.getInstance().getRemoteUser();
        Value[] voters = document.getProperty(VOTER_PROP).getValues();
        Value newVoter = session.getValueFactory().createValue(userId);
        ArrayList<Value> newVoterList = new ArrayList<Value>();
        newVoterList.addAll(Arrays.asList(voters));
        newVoterList.add(newVoter);
        document.setProperty(VOTE_TOTAL_PROP, voteTotal + 1L);
        document.setProperty(VOTING_RATE_PROP, fomatedRating);
        document.setProperty(VOTER_PROP, newVoterList.toArray(new Value[newVoterList.size()]));
        document.save();
        session.save();
    }
}

