/*
 * Decompiled with CFR 0.152.
 */
package hero.mapper;

import hero.interfaces.BnRoleLocal;
import hero.mapper.RoleMapperI;
import hero.util.HeroException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExoOrganizationMapper
implements RoleMapperI {
    public static Collection<String> GetUsersFromMembershipAndGroup(String membershipAndGroup) {
        ArrayList<String> users = new ArrayList<String>();
        try {
            PortalContainer container = PortalContainer.getInstance();
            OrganizationService organization = (OrganizationService)container.getComponentInstanceOfType(OrganizationService.class);
            String[] tokens = membershipAndGroup.split(":");
            String membership = null;
            String group = null;
            if (tokens.length == 2) {
                membership = tokens[0];
                group = tokens[1];
            } else {
                membership = "*";
                group = membershipAndGroup;
                System.err.println("Warning : The specified Bonita role does not conform to the syntax membership:group.");
            }
            UserHandler userHandler = organization.getUserHandler();
            PageList pageList = userHandler.findUsersByGroup(group);
            List usersInGroup = pageList.getAll();
            for (User user : usersInGroup) {
                String userName = user.getUserName();
                if (!"*".equals(membership) && organization.getMembershipHandler().findMembershipByUserGroupAndType(userName, group, membership) == null) continue;
                users.add(userName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return users;
    }

    public Collection searchMembers(Object bean, BnRoleLocal role, String userName) throws HeroException {
        return ExoOrganizationMapper.GetUsersFromMembershipAndGroup(role.getName());
    }
}

