/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.workflow.impl.bonita;

import hero.interfaces.BnNodeLocal;
import hero.interfaces.BnNodeLocalHome;
import hero.interfaces.BnNodePK;
import hero.interfaces.BnNodeUtil;
import hero.interfaces.BnProjectLocal;
import hero.interfaces.BnProjectLocalHome;
import hero.interfaces.BnProjectUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.resource.Resource;
import org.apache.velocity.runtime.resource.ResourceFactory;
import org.apache.velocity.runtime.resource.loader.ResourceLoader;
import org.exoplatform.services.templates.velocity.ResourceLoaderPlugin;
import org.exoplatform.services.workflow.FileDefinition;
import org.exoplatform.services.workflow.WorkflowFileDefinitionService;
import org.exoplatform.services.workflow.impl.bonita.WorkflowServiceContainerHelper;

public class PARResourceLoaderImpl
extends ResourceLoaderPlugin {
    private WorkflowFileDefinitionService fileDefinitionService = null;
    public static final String RESOURCE_NAME_PREFIX = "par:";
    private Map<String, Resource> resources = null;

    public boolean canLoadResource(String s) {
        return s.startsWith(RESOURCE_NAME_PREFIX);
    }

    public long getLastModified(Resource resource) {
        return 0L;
    }

    public Resource getResource(String resourceName, int resourceType, String encoding) throws ResourceNotFoundException, ParseErrorException, Exception {
        Resource resource = this.resources.get(resourceName);
        if (resource == null) {
            String path = resourceName.substring(RESOURCE_NAME_PREFIX.length(), resourceName.length());
            resource = ResourceFactory.getResource((String)path, (int)resourceType);
            resource.setRuntimeServices(this.rsvc);
            resource.setName(path);
            resource.setEncoding(encoding);
            resource.setResourceLoader((ResourceLoader)this);
            resource.process();
        }
        return resource;
    }

    public synchronized InputStream getResourceStream(String fileLocation) throws ResourceNotFoundException {
        ByteArrayInputStream inputStream = null;
        try {
            String[] fileLocationSplit = fileLocation.split(":");
            String taskId = fileLocationSplit[0];
            BnNodeLocalHome nodeHome = BnNodeUtil.getLocalHome();
            BnNodeLocal node = nodeHome.findByPrimaryKey(new BnNodePK(taskId));
            String taskName = node.getName();
            String instanceName = node.getBnProject().getName();
            String processModelName = WorkflowServiceContainerHelper.getModelName(instanceName);
            BnProjectLocalHome projectHome = BnProjectUtil.getLocalHome();
            BnProjectLocal project = projectHome.findByName(processModelName);
            String processModelId = project.getId();
            FileDefinition fileDefinition = this.fileDefinitionService.retrieve(processModelId);
            String customizedViewName = fileDefinition.getCustomizedView(taskName);
            byte[] customizedViewBytes = fileDefinition.getEntry(customizedViewName);
            inputStream = new ByteArrayInputStream(customizedViewBytes);
        }
        catch (Exception e) {
            throw new ResourceNotFoundException("Cannot retrieve data in process " + fileLocation + ". Make sure you have a valid location.");
        }
        return inputStream;
    }

    public void init(ExtendedProperties configuration) {
    }

    public boolean isSourceModified(Resource resource) {
        return false;
    }

    public PARResourceLoaderImpl(WorkflowFileDefinitionService fileDefinitionService) throws Exception {
        this.fileDefinitionService = fileDefinitionService;
        this.resources = new WeakHashMap<String, Resource>();
    }
}

