/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.frameworks.webdavclient;

import java.io.ByteArrayOutputStream;
import java.util.BitSet;

public class TextUtils {
    public static BitSet URISave;
    public static BitSet URISaveEx;
    public static final char[] hexTable;

    public static String Escape(String string, char escape, boolean isPath) {
        try {
            BitSet validChars = isPath ? URISaveEx : URISave;
            byte[] bytes = string.getBytes("utf-8");
            StringBuffer out = new StringBuffer(bytes.length);
            for (int i = 0; i < bytes.length; ++i) {
                int c = bytes[i] & 0xFF;
                if (validChars.get(c) && c != escape) {
                    out.append((char)c);
                    continue;
                }
                out.append(escape);
                out.append(hexTable[c >> 4 & 0xF]);
                out.append(hexTable[c & 0xF]);
            }
            return out.toString();
        }
        catch (Exception exc) {
            throw new InternalError(exc.toString());
        }
    }

    public static String UnEscape(String string, char escape) {
        ByteArrayOutputStream out = new ByteArrayOutputStream(string.length());
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == escape) {
                try {
                    out.write(Integer.parseInt(string.substring(i + 1, i + 3), 16));
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException();
                }
                i += 2;
                continue;
            }
            out.write(c);
        }
        try {
            return new String(out.toByteArray(), "utf-8");
        }
        catch (Exception exc) {
            throw new InternalError(exc.toString());
        }
    }

    static {
        int i;
        URISave = new BitSet(256);
        for (i = 97; i <= 122; ++i) {
            URISave.set(i);
        }
        for (i = 65; i <= 90; ++i) {
            URISave.set(i);
        }
        for (i = 48; i <= 57; ++i) {
            URISave.set(i);
        }
        URISave.set(45);
        URISave.set(95);
        URISave.set(46);
        URISave.set(33);
        URISave.set(126);
        URISave.set(42);
        URISave.set(39);
        URISave.set(40);
        URISave.set(41);
        URISaveEx = (BitSet)URISave.clone();
        URISaveEx.set(47);
        hexTable = "0123456789abcdef".toCharArray();
    }
}

