/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.frameworks.webdavclient.search;

import org.exoplatform.frameworks.webdavclient.Log;
import org.exoplatform.frameworks.webdavclient.search.AbstractQuery;
import org.exoplatform.frameworks.webdavclient.search.basicsearch.BasicSearchCondition;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BasicSearchQuery
extends AbstractQuery {
    private String fromHref = "";
    private int fromDepth = Integer.MAX_VALUE;
    private BasicSearchCondition condition;

    public BasicSearchQuery() {
        Log.info("Construct..............");
    }

    public void setFrom(String fromHref, int fromDepth) {
        this.fromHref = fromHref;
        this.fromDepth = fromDepth;
    }

    public void setCondition(BasicSearchCondition condition) {
        this.condition = condition;
    }

    public Element toXml(Document xmlDocument) {
        Log.info("To XML...............");
        Element basicSearchEl = xmlDocument.createElement("A:basicsearch");
        Element selectEl = xmlDocument.createElement("A:select");
        basicSearchEl.appendChild(selectEl);
        selectEl.appendChild(this.properties.toXml(xmlDocument));
        Element fromEl = xmlDocument.createElement("A:from");
        basicSearchEl.appendChild(fromEl);
        Element scopeEl = xmlDocument.createElement("A:scope");
        fromEl.appendChild(scopeEl);
        Element hrefEl = xmlDocument.createElement("A:href");
        scopeEl.appendChild(hrefEl);
        hrefEl.setTextContent(this.fromHref);
        Element depthEl = xmlDocument.createElement("A:depth");
        scopeEl.appendChild(depthEl);
        if (this.fromDepth == Integer.MAX_VALUE) {
            depthEl.setTextContent("infinity");
        } else {
            depthEl.setTextContent("" + this.fromDepth);
        }
        Element whereEl = xmlDocument.createElement("A:where");
        basicSearchEl.appendChild(whereEl);
        whereEl.appendChild(this.condition.toXml(xmlDocument));
        return basicSearchEl;
    }
}

