/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.applications.ooplugin;

import com.sun.star.awt.ActionEvent;
import com.sun.star.awt.XTextComponent;
import com.sun.star.awt.XToolkit;
import com.sun.star.awt.XWindow;
import com.sun.star.beans.PropertyValue;
import com.sun.star.document.XDocumentInfo;
import com.sun.star.document.XDocumentInfoSupplier;
import com.sun.star.frame.XDesktop;
import com.sun.star.frame.XFrame;
import com.sun.star.frame.XModel;
import com.sun.star.frame.XStorable;
import com.sun.star.io.IOException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import com.sun.star.uri.ExternalUriReferenceTranslator;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URLDecoder;
import org.exoplatform.applications.ooplugin.BrowseDialog;
import org.exoplatform.applications.ooplugin.LocalFileSystem;
import org.exoplatform.applications.ooplugin.Log;
import org.exoplatform.applications.ooplugin.WebDavConfig;
import org.exoplatform.applications.ooplugin.events.ActionListener;
import org.exoplatform.frameworks.webdavclient.commands.DavPut;
import org.exoplatform.frameworks.webdavclient.documents.ResponseDoc;
import org.exoplatform.frameworks.webdavclient.properties.DisplayNameProp;

public class SaveDialog
extends BrowseDialog {
    public static final String DIALOG_NAME = "_SaveDialog";
    private Thread launchThread;
    private Thread enableSaveThread;
    private XStorable xStorable;
    private XDocumentInfo xDocumentInfo;
    private XModel xModel;
    private String localFilePath = "";
    private static final String EDT_NAME = "edtName";
    private static final String BTN_SAVE = "btnSave";
    private boolean isSaveAs = false;

    public SaveDialog(WebDavConfig config, XComponentContext xComponentContext, XFrame xFrame, XToolkit xToolkit, boolean isSaveAs) {
        super(config, xComponentContext, xFrame, xToolkit);
        this.dialogName = DIALOG_NAME;
        this.isSaveAs = isSaveAs;
        this.addHandler(BTN_SAVE, 1, new SaveClick());
        this.launchThread = new LaunchThread();
        this.launchThread.start();
    }

    protected void disableAll() {
        super.disableAll();
    }

    protected void enableAll() {
        super.enableAll();
    }

    protected String getFileName() {
        XTextComponent xComboText = (XTextComponent)UnoRuntime.queryInterface(XTextComponent.class, (Object)this.xControlContainer.getControl(EDT_NAME));
        return xComboText.getText();
    }

    protected void setFileName(String fileName) {
        XTextComponent xComboText = (XTextComponent)UnoRuntime.queryInterface(XTextComponent.class, (Object)this.xControlContainer.getControl(EDT_NAME));
        xComboText.setText(fileName);
    }

    protected void doSelectItem() {
        int selectedPos = this.getSelectedItemPos();
        if (selectedPos < 0) {
            return;
        }
        ResponseDoc response = (ResponseDoc)this.responses.get(selectedPos);
        if (this.isCollection(response)) {
            this.doPropFindResponse(response);
        } else {
            try {
                DisplayNameProp displayNameProperty = (DisplayNameProp)response.getProperty("displayname");
                this.setFileName(displayNameProperty.getDisplayName());
            }
            catch (Exception exc) {
                Log.info("Can't open remote file... " + exc.getMessage(), exc);
            }
        }
    }

    protected void doSaveFile() throws Exception {
        String fileName = this.getFileName();
        if ("".equals(fileName)) {
            this.showMessageBox("File name required!");
            return;
        }
        String repoFilePath = this.currentPath;
        repoFilePath = repoFilePath.endsWith("/") ? repoFilePath + fileName : repoFilePath + "/" + fileName;
        if ("".equals(this.localFilePath)) {
            this.prepareTmpPath(this.currentPath);
            String storeToPath = LocalFileSystem.getDocumentsPath() + File.separatorChar + "repository" + this.currentPath;
            storeToPath = "/".equals(this.currentPath) ? storeToPath + fileName : storeToPath + "/" + fileName;
            storeToPath = storeToPath.replace("\\", "/");
            this.storeLocal(storeToPath);
            if (this.doSave(storeToPath, repoFilePath)) {
                this.setSessionPath(repoFilePath);
                this.xDialog.endExecute();
            }
            return;
        }
        this.xStorable.store();
        if (this.doSave(this.localFilePath, repoFilePath)) {
            this.setSessionPath(repoFilePath);
            this.xDialog.endExecute();
        }
    }

    protected void setSessionPath(String path) throws IndexOutOfBoundsException {
        this.xDocumentInfo.setUserFieldName((short)0, "eXoRemoteFileName");
        this.xDocumentInfo.setUserFieldValue((short)0, path);
    }

    protected String getSessionPath() throws IndexOutOfBoundsException {
        if (this.xDocumentInfo.getUserFieldName((short)0).compareTo("eXoRemoteFileName") == 0 && this.xDocumentInfo.getUserFieldValue((short)0).length() > 0) {
            return this.xDocumentInfo.getUserFieldValue((short)0);
        }
        return null;
    }

    public void storeLocal(String url) {
        try {
            String path = ExternalUriReferenceTranslator.create((XComponentContext)this.xComponentContext).translateToInternal("file:///" + url.replace("\\", "/"));
            if (path.length() == 0) {
                throw new RuntimeException();
            }
            PropertyValue asTemplate = new PropertyValue();
            PropertyValue[] loadProps = new PropertyValue[]{asTemplate};
            this.xStorable.storeAsURL(path, loadProps);
        }
        catch (IOException e) {
            Log.info("Exception", e);
        }
    }

    public boolean launchBeforeOpen() {
        if (!super.launchBeforeOpen()) {
            return false;
        }
        try {
            this.initDefaults();
            if ("".equals(this.localFilePath)) {
                return true;
            }
            if (this.isSaveAs) {
                if (this.getSessionPath() != null) {
                    String onlyPath;
                    String sessPath = this.getSessionPath();
                    this.currentPath = onlyPath = sessPath.substring(0, sessPath.lastIndexOf("/"));
                    String onlyName = sessPath.substring(sessPath.lastIndexOf("/") + 1);
                    this.setFileName(onlyName);
                } else {
                    String onlyName = this.localFilePath.substring(this.localFilePath.lastIndexOf("/") + 1);
                    this.setFileName(onlyName);
                }
                return true;
            }
            String onlyName = this.localFilePath.substring(this.localFilePath.lastIndexOf("/") + 1);
            this.setFileName(onlyName);
            String repositoryFolderName = LocalFileSystem.getDocumentsPath() + File.separatorChar + "repository";
            repositoryFolderName = repositoryFolderName.replace("\\", "/");
            if (this.getSessionPath() != null) {
                String remotePath = this.getSessionPath();
                this.xStorable.store();
                this.doSave(this.localFilePath, remotePath);
                return false;
            }
            if (this.localFilePath.startsWith(repositoryFolderName)) {
                this.xStorable.store();
                String remotePath = this.localFilePath.substring(repositoryFolderName.length());
                this.doSave(this.localFilePath, remotePath);
                return false;
            }
            return true;
        }
        catch (Exception exc) {
            Log.info("Unhandled ecxeption. " + exc.getMessage(), exc);
            return false;
        }
    }

    protected void initDefaults() throws Exception {
        XMultiComponentFactory xMultiComponentFactory = this.xComponentContext.getServiceManager();
        Object descTop = xMultiComponentFactory.createInstanceWithContext("com.sun.star.frame.Desktop", this.xComponentContext);
        XDesktop xDescTop = (XDesktop)UnoRuntime.queryInterface(XDesktop.class, (Object)descTop);
        XComponent xComponent = xDescTop.getCurrentComponent();
        this.xStorable = (XStorable)UnoRuntime.queryInterface(XStorable.class, (Object)xComponent);
        XDocumentInfoSupplier xDocumentInfoSupplier = (XDocumentInfoSupplier)UnoRuntime.queryInterface(XDocumentInfoSupplier.class, (Object)xComponent);
        this.xDocumentInfo = xDocumentInfoSupplier.getDocumentInfo();
        this.xModel = (XModel)UnoRuntime.queryInterface(XModel.class, (Object)xComponent);
        this.localFilePath = URLDecoder.decode(this.xModel.getURL().replaceFirst("file:///", ""));
    }

    protected boolean doSave(String localPath, String remotePath) {
        try {
            File inFile = new File(localPath);
            FileInputStream inStream = new FileInputStream(inFile);
            DavPut davPut = new DavPut(this.config.getContext());
            davPut.setResourcePath(remotePath);
            davPut.setRequestInputStream((InputStream)inStream, (long)inStream.available());
            int status = davPut.execute();
            if (status == 201) {
                this.showMessageBox("File " + this.config.getContext().getServerPrefix() + remotePath + " succesfully saved!");
                return true;
            }
            this.showMessageBox("Can't store file. Error code: " + status);
        }
        catch (Exception exc) {
            Log.info("Unhandled exception. " + exc.getMessage(), exc);
        }
        return false;
    }

    private class EnableSaveThread
    extends Thread {
        private EnableSaveThread() {
        }

        public void run() {
            try {
                while (true) {
                    Thread.sleep(100L);
                    if ("".equals(SaveDialog.this.getFileName())) {
                        ((XWindow)UnoRuntime.queryInterface(XWindow.class, (Object)SaveDialog.this.xControlContainer.getControl(SaveDialog.BTN_SAVE))).setEnable(false);
                        continue;
                    }
                    ((XWindow)UnoRuntime.queryInterface(XWindow.class, (Object)SaveDialog.this.xControlContainer.getControl(SaveDialog.BTN_SAVE))).setEnable(true);
                }
            }
            catch (Exception exception) {
                return;
            }
        }
    }

    private class LaunchThread
    extends Thread {
        private LaunchThread() {
        }

        public void run() {
            try {
                while (!SaveDialog.this.enabled) {
                    Thread.sleep(100L);
                }
                Thread.sleep(100L);
                SaveDialog.this.enableSaveThread = new EnableSaveThread();
                SaveDialog.this.enableSaveThread.start();
                SaveDialog.this.doPropFind();
            }
            catch (Exception exc) {
                Log.info("Unhandled exception. " + exc.getMessage(), exc);
            }
        }
    }

    private class SaveClick
    extends ActionListener {
        private SaveClick() {
        }

        public void actionPerformed(ActionEvent arg0) {
            try {
                SaveDialog.this.doSaveFile();
            }
            catch (Exception exc) {
                Log.info("Unhandled exception", exc);
            }
        }
    }
}

