/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.frameworks.davclient.commands;

import org.apache.commons.logging.Log;
import org.exoplatform.frameworks.davclient.ServerLocation;
import org.exoplatform.frameworks.davclient.commands.DavCommand;
import org.exoplatform.frameworks.davclient.documents.DocumentApi;
import org.exoplatform.frameworks.davclient.documents.DocumentManager;
import org.exoplatform.frameworks.davclient.documents.Multistatus;
import org.exoplatform.frameworks.davclient.request.PropertyList;
import org.exoplatform.services.log.ExoLogger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class MultistatusCommand
extends DavCommand {
    private static Log log = ExoLogger.getLogger((String)"jcr.MultistatusCommand");
    protected PropertyList propList = new PropertyList();
    protected String xmlName = "propfind";
    protected DocumentApi multistatusDocument = null;

    public MultistatusCommand(ServerLocation location) throws Exception {
        super(location);
    }

    public void requireAllProperties() {
        this.propList.clearProperies();
    }

    public void setRequiredProperty(String propertyName) {
        this.propList.setProperty(propertyName);
    }

    public Document toXml(Document xmlDocument) {
        Element propFindEl = xmlDocument.createElementNS("DAV:", "A:" + this.xmlName);
        xmlDocument.appendChild(propFindEl);
        propFindEl.appendChild(this.propList.toXml(xmlDocument));
        return xmlDocument;
    }

    public void finalExecute() {
        try {
            if (this.client.getReplyCode() != 207) {
                return;
            }
        }
        catch (Exception exc) {
            log.info((Object)("Unhandled exception. " + exc.getMessage()), (Throwable)exc);
        }
        this.multistatusDocument = DocumentManager.getResponseDocument(this.client.getResponseStream());
    }

    public Multistatus getMultistatus() {
        return (Multistatus)this.multistatusDocument;
    }
}

