/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.frameworks.davclient.request;

import java.util.ArrayList;
import org.exoplatform.frameworks.davclient.request.NameSpaceRegistry;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PropertyList {
    protected ArrayList<String> properties = new ArrayList();
    protected NameSpaceRegistry nsRegistry = new NameSpaceRegistry();

    public void setProperty(String propertyName) {
        if (this.nsRegistry.registerNameSpace(propertyName)) {
            this.properties.add(propertyName);
        } else {
            this.properties.add("A:" + propertyName);
        }
    }

    public void clearProperies() {
        this.properties.clear();
        this.nsRegistry.clearNameSpaces();
    }

    public boolean isAllProp() {
        return this.properties.size() == 0;
    }

    public Element toXml(Document xmlDocument) {
        Element propEl = null;
        if (this.isAllProp()) {
            propEl = xmlDocument.createElement("A:allprop");
        } else {
            propEl = xmlDocument.createElement("A:prop");
            this.nsRegistry.fillNameSpaces(propEl);
            for (int i = 0; i < this.properties.size(); ++i) {
                String curPropName = this.properties.get(i);
                Element curPropEl = xmlDocument.createElement(curPropName);
                propEl.appendChild(curPropEl);
            }
        }
        return propEl;
    }
}

