/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.ftp;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.ArrayList;
import javax.jcr.Credentials;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import org.apache.commons.logging.Log;
import org.exoplatform.frameworks.jcr.JCRAppSessionFactory;
import org.exoplatform.frameworks.jcr.SingleRepositorySessionFactory;
import org.exoplatform.services.ftp.FtpClientCommandThread;
import org.exoplatform.services.ftp.FtpClientSession;
import org.exoplatform.services.ftp.FtpClientTimeOutThread;
import org.exoplatform.services.ftp.FtpConst;
import org.exoplatform.services.ftp.FtpDataTransiver;
import org.exoplatform.services.ftp.FtpServer;
import org.exoplatform.services.log.ExoLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FtpClientSessionImpl
implements FtpClientSession {
    private static Log log = ExoLogger.getLogger((String)"jcr.ftpservice.FtpClientSessionImpl");
    private FtpServer ftpServer;
    FtpClientCommandThread commandThread;
    FtpClientTimeOutThread timeOutThread;
    private FtpDataTransiver transiver = null;
    private Socket clientSocket;
    private JCRAppSessionFactory sessionFactory;
    private ArrayList<String> path = new ArrayList();
    private String serverIp;
    private String userName = "";
    private String userPass = "";
    private boolean logged = false;
    private String prevCommand = "";
    private String prevParams = "";
    private String prevParamsEx = "";
    private boolean isLoggedOut = false;

    public FtpClientSessionImpl(FtpServer ftpServer, Socket clientSocket) throws Exception {
        this.ftpServer = ftpServer;
        this.clientSocket = clientSocket;
        SocketAddress addr = clientSocket.getLocalSocketAddress();
        String serverAddr = addr.toString();
        if (serverAddr.startsWith("/")) {
            serverAddr = serverAddr.substring(1);
        }
        String[] serverLocations = serverAddr.split(":");
        this.serverIp = serverLocations[0];
        this.welcomeClient();
        this.commandThread = new FtpClientCommandThread(this);
        this.commandThread.start();
        if (this.getFtpServer().getConfiguration().isNeedTimeOut()) {
            this.timeOutThread = new FtpClientTimeOutThread(this);
            this.timeOutThread.start();
        }
    }

    @Override
    public Socket getClientSocket() {
        return this.clientSocket;
    }

    @Override
    public void reply(String replyString) throws IOException {
        String encodingType = this.ftpServer.getConfiguration().getClientSideEncoding();
        try {
            byte[] data = replyString.getBytes(encodingType);
            this.clientSocket.getOutputStream().write(data);
        }
        catch (UnsupportedEncodingException eexc) {
            log.info((Object)("Unsupported encoding exception. See for CLIENT-SIDE-ENCODING parameter. " + eexc.getMessage()), (Throwable)eexc);
            byte[] data = replyString.getBytes();
            this.clientSocket.getOutputStream().write(data);
        }
        this.clientSocket.getOutputStream().write("\r\n".getBytes());
    }

    @Override
    public FtpServer getFtpServer() {
        return this.ftpServer;
    }

    protected void welcomeClient() throws IOException {
        for (int i = 0; i < FtpConst.eXoLogo.length; ++i) {
            this.reply(FtpConst.eXoLogo[i]);
        }
    }

    @Override
    public void logout() {
        if (this.isLoggedOut) {
            return;
        }
        this.isLoggedOut = true;
        this.commandThread.interrupt();
        if (this.timeOutThread != null) {
            this.timeOutThread.interrupt();
        }
        this.closeDataTransiver();
        try {
            this.clientSocket.close();
        }
        catch (Exception exc) {
            log.info((Object)("Unhandled exception. " + exc.getMessage()), (Throwable)exc);
        }
        this.getFtpServer().unRegisterClient(this);
        if (this.sessionFactory != null) {
            this.sessionFactory.close();
        }
    }

    @Override
    public boolean isLogged() {
        return this.logged;
    }

    @Override
    public void setUserName(String userName) {
        this.userName = userName;
        this.logged = false;
    }

    @Override
    public void setPassword(String userPass) {
        this.userPass = userPass;
        if (this.sessionFactory != null) {
            this.sessionFactory.close();
        }
        SimpleCredentials credentials = new SimpleCredentials(this.userName, userPass.toCharArray());
        this.sessionFactory = new SingleRepositorySessionFactory(this.ftpServer.getRepository(), (Credentials)credentials);
        this.logged = true;
    }

    @Override
    public String getUserName() {
        return this.userName;
    }

    @Override
    public String getUserPassword() {
        return this.userPass;
    }

    @Override
    public String getServerIp() {
        return this.serverIp;
    }

    @Override
    public void setDataTransiver(FtpDataTransiver newTransiver) {
        if (this.transiver != null) {
            this.transiver.close();
        }
        this.transiver = newTransiver;
    }

    @Override
    public void closeDataTransiver() {
        if (this.transiver != null) {
            this.transiver.close();
            this.transiver = null;
        }
    }

    @Override
    public FtpDataTransiver getDataTransiver() {
        return this.transiver;
    }

    @Override
    public void setPrevCommand(String prevCommand) {
        this.prevCommand = prevCommand;
    }

    @Override
    public void setPrevParams(String prevParams) {
        this.prevParams = prevParams;
    }

    @Override
    public void setPrevParamsEx(String prevParamsEx) {
        this.prevParamsEx = prevParamsEx;
    }

    @Override
    public String getPrevCommand() {
        return this.prevCommand;
    }

    @Override
    public String getPrevParams() {
        return this.prevParams;
    }

    @Override
    public String getPrevParamsEx() {
        return this.prevParamsEx;
    }

    @Override
    public ArrayList<String> getFullPath(String resPath) {
        ArrayList<String> curPath = this.getPath();
        if (resPath.startsWith("/")) {
            curPath.clear();
        }
        String[] pathes = resPath.split("/");
        for (int i = 0; i < pathes.length; ++i) {
            if ("".equals(pathes[i])) continue;
            if ("..".equals(pathes[i])) {
                if (curPath.size() == 0) continue;
                curPath.remove(curPath.size() - 1);
                continue;
            }
            curPath.add(pathes[i]);
        }
        return curPath;
    }

    @Override
    public String getRepoPath(ArrayList<String> repoPath) {
        String curPath = "/";
        for (int i = 1; i < repoPath.size(); ++i) {
            curPath = curPath + repoPath.get(i);
            if (i >= repoPath.size() - 1) continue;
            curPath = curPath + "/";
        }
        return curPath;
    }

    @Override
    public Session getSession(String workspaceName) throws Exception {
        Session curSession = this.sessionFactory.getSession(workspaceName);
        curSession.refresh(false);
        return curSession;
    }

    @Override
    public String changePath(String resPath) {
        ArrayList<String> newPath = this.getFullPath(resPath);
        if (newPath.size() == 0) {
            this.path = new ArrayList();
            return "250 %s command successful";
        }
        String repoWorkspace = newPath.get(0);
        String repoPath = this.getRepoPath(newPath);
        try {
            Session curSession = this.getSession(repoWorkspace);
            Node curNode = (Node)curSession.getItem(repoPath);
            if (curNode.isNodeType("nt:file")) {
                return "550 %s: Permission denied";
            }
            this.path = (ArrayList)newPath.clone();
            return "250 %s command successful";
        }
        catch (RepositoryException exc) {
            return "550 %s: Permission denied";
        }
        catch (Exception exc) {
            log.info((Object)("Unhandled exception. " + exc.getMessage()), (Throwable)exc);
            return "550 %s: Permission denied";
        }
    }

    @Override
    public ArrayList<String> getPath() {
        return (ArrayList)this.path.clone();
    }

    @Override
    public void refreshTimeOut() {
        if (this.timeOutThread != null) {
            this.timeOutThread.refreshTimeOut();
        }
    }
}

